/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.ASignature;
import convex.core.crypto.InsecureRandom;
import convex.core.crypto.Providers;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.SignedData;
import convex.core.util.Utils;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public abstract class AKeyPair {
    public static final int SEED_LENGTH = 32;
    protected static final String ED25519 = "Ed25519";
    private KeyPair keyPair = null;

    public final byte[] getPublicKeyBytes() {
        return this.getAccountKey().getBytes();
    }

    public abstract AccountKey getAccountKey();

    public abstract <R extends ACell> SignedData<R> signData(R var1);

    public final boolean equals(Object a) {
        if (!(a instanceof AKeyPair)) {
            return false;
        }
        return this.equals((AKeyPair)a);
    }

    public abstract boolean equals(AKeyPair var1);

    public abstract ASignature sign(AArrayBlob var1);

    public static AKeyPair createSeeded(long seed) {
        InsecureRandom r = new InsecureRandom(seed);
        Blob seedBlob = Blob.createRandom(r, 32L);
        return AKeyPair.create(seedBlob);
    }

    public static AKeyPair generate() {
        return Providers.generate();
    }

    public static AKeyPair create(byte[] keyMaterial) {
        return AKeyPair.create(Blob.wrap(keyMaterial));
    }

    public static AKeyPair create(Blob seed) {
        return Providers.generate(seed);
    }

    public PrivateKey getPrivate() {
        return this.getJCAKeyPair().getPrivate();
    }

    public PublicKey getPublic() {
        return this.getJCAKeyPair().getPublic();
    }

    public String toString() {
        return "Keypair for: " + String.valueOf(this.getAccountKey());
    }

    public KeyPair getJCAKeyPair() {
        if (this.keyPair == null) {
            PublicKey pub = AKeyPair.publicKeyFromBytes(this.getAccountKey().getBytes());
            PrivateKey priv = AKeyPair.privateKeyFromBytes(this.getSeed().getBytes());
            this.keyPair = new KeyPair(pub, priv);
        }
        return this.keyPair;
    }

    protected static Blob extractSeed(PrivateKey priv) {
        byte[] data = priv.getEncoded();
        int n = data.length;
        Blob seed = Blob.wrap(data, n - 32, 32);
        return seed;
    }

    public abstract Blob getSeed();

    public static AKeyPair create(PrivateKey privateKey) {
        Ed25519PrivateKeyParameters privateKeyParam = new Ed25519PrivateKeyParameters(privateKey.getEncoded(), 16);
        Ed25519PublicKeyParameters publicKeyParam = privateKeyParam.generatePublicKey();
        PublicKey generatedPublicKey = AKeyPair.publicKeyFromBytes(publicKeyParam.getEncoded());
        return AKeyPair.create(generatedPublicKey, privateKey);
    }

    public static AKeyPair create(PublicKey publicKey, PrivateKey privateKey) {
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return AKeyPair.create(keyPair);
    }

    public static AKeyPair create(KeyPair keyPair) {
        Blob seed = AKeyPair.extractSeed(keyPair.getPrivate());
        return Providers.generate(seed);
    }

    public static PrivateKey privateKeyFromBytes(byte[] key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(key));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static AccountKey extractAccountKey(PublicKey publicKey) {
        byte[] bytes = publicKey.getEncoded();
        int n = bytes.length;
        return AccountKey.wrap(bytes, n - 32);
    }

    public static PrivateKey privateKeyFromBlob(Blob encodedKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(encodedKey.getBytes());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static PrivateKey privateFromBytes(byte[] privKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(privKey));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey result = keyFactory.generatePrivate(pkcs8KeySpec);
            return result;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static PublicKey publicKeyFromBytes(byte[] key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyInfo.getEncoded());
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            return publicKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new Error(e);
        }
    }

    static {
        Providers.init();
    }
}

