/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.ErrorCodes;
import convex.core.ResultContext;
import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.ARecordGeneric;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.impl.AExceptional;
import convex.core.lang.impl.ErrorValue;
import convex.core.lang.impl.RecordFormat;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public final class Result
extends ARecordGeneric {
    private static final RecordFormat RESULT_FORMAT = RecordFormat.of(Keywords.ID, Keywords.RESULT, Keywords.ERROR, Keywords.LOG, Keywords.INFO);
    private static final long FIELD_COUNT = RESULT_FORMAT.count();
    private static final long ID_POS = RESULT_FORMAT.indexFor(Keywords.ID);
    private static final long RESULT_POS = RESULT_FORMAT.indexFor(Keywords.RESULT);
    private static final long ERROR_POS = RESULT_FORMAT.indexFor(Keywords.ERROR);
    private static final long INFO_POS = RESULT_FORMAT.indexFor(Keywords.INFO);
    private static final long LOG_POS = RESULT_FORMAT.indexFor(Keywords.LOG);
    private static final AVector<AVector<ACell>> EMPTY_LOG = null;

    private Result(AVector<ACell> values) {
        super(RESULT_FORMAT, values);
    }

    public static Result buildFromVector(AVector<ACell> values) {
        return new Result(values);
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode, AHashMap<Keyword, ACell> info) {
        return Result.buildFromVector(Vectors.of(id, value, errorCode, EMPTY_LOG, info));
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode) {
        return Result.create(id, value, errorCode, null);
    }

    public static Result create(CVMLong id, ACell value) {
        return Result.create(id, value, null, null);
    }

    public static Result error(Keyword errorCode, AString message) {
        return Result.error(errorCode, message, null);
    }

    private static Result error(Keyword errorCode, AString message, AHashMap<Keyword, ACell> info) {
        return Result.create(CVMLong.ZERO, message, errorCode, info);
    }

    public ACell getID() {
        return this.values.get(ID_POS);
    }

    public <T extends ACell> T getValue() {
        return this.values.get(RESULT_POS);
    }

    public AVector<AString> getTrace() {
        AMap<Keyword, ACell> info = this.getInfo();
        if (info instanceof AMap) {
            AMap<Keyword, ACell> m = info;
            return (AVector)m.get(Keywords.TRACE);
        }
        return null;
    }

    public AMap<Keyword, ACell> getInfo() {
        return (AMap)this.values.get(INFO_POS);
    }

    public AVector<AVector<ACell>> getLog() {
        AVector<AVector<ACell>> log = (AVector<AVector<ACell>>)this.values.get(LOG_POS);
        if (log == null) {
            log = Vectors.empty();
        }
        return log;
    }

    public ACell getErrorCode() {
        return this.values.get(ERROR_POS);
    }

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    @Override
    protected Result withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Result(newValues);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
        String problem = Result.checkValues(this.values);
        if (problem != null) {
            throw new InvalidDataException(problem, this);
        }
    }

    private static String checkValues(AVector<ACell> values) {
        if (values.count() != FIELD_COUNT) {
            return "Wrong number of fields for Result";
        }
        ACell id = values.get(ID_POS);
        if (id != null && !(id instanceof CVMLong)) {
            return "Result ID must be a CVM long value";
        }
        ACell info = values.get(INFO_POS);
        if (info != null && !(info instanceof AHashMap)) {
            return "Result info must be a hash map";
        }
        ACell log = values.get(LOG_POS);
        if (log != null && !(log instanceof AVector)) {
            return "Result log must be a Vector";
        }
        return null;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -83;
        pos = this.values.encodeRaw(bs, pos);
        return pos;
    }

    public static Result read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<ACell> v = Vectors.read(b, epos);
        epos += Format.getEncodingLength(v);
        String problem = Result.checkValues(v);
        if (problem != null) {
            throw new BadFormatException(problem);
        }
        Blob enc = v.getEncoding();
        Result r = Result.buildFromVector(v);
        v.attachEncoding(null);
        r.attachEncoding(enc);
        return r;
    }

    public boolean isError() {
        return this.getErrorCode() != null;
    }

    public static Result fromContext(CVMLong id, ResultContext rc) {
        Context ctx = rc.context;
        Object result = ctx.getValue();
        ACell errorCode = null;
        Object info = Maps.empty();
        if (result instanceof AExceptional) {
            AExceptional ex = (AExceptional)result;
            result = ex.getMessage();
            errorCode = ex.getCode();
            if (ex instanceof ErrorValue) {
                ErrorValue ev = (ErrorValue)ex;
                AVector trace = Vectors.create(ev.getTrace());
                Address errorAddress = ev.getAddress();
                info = ((AHashMap)info).assoc(Keywords.TRACE, trace);
                info = ((AHashMap)info).assoc(Keywords.EADDR, errorAddress);
            }
        }
        if (rc.memUsed > 0L) {
            info = ((AHashMap)info).assoc(Keywords.MEM, CVMLong.create(rc.memUsed));
        }
        if (rc.totalFees > 0L) {
            info = ((AHashMap)info).assoc(Keywords.FEES, CVMLong.create(rc.totalFees));
        }
        if (rc.juiceUsed > 0L) {
            info = ((AHashMap)info).assoc(Keywords.JUICE, CVMLong.create(rc.juiceUsed));
        }
        return Result.create(id, (ACell)result, errorCode, info);
    }

    public Result withExtraInfo(Map<Keyword, ACell> extInfo) {
        if (extInfo != null && !extInfo.isEmpty()) {
            ADataStructure info = this.getInfo();
            if (info == null) {
                info = Maps.empty();
            }
            for (Map.Entry<Keyword, ACell> me : extInfo.entrySet()) {
                info = info.assoc(me.getKey(), me.getValue());
            }
            return new Result((AVector<ACell>)this.values.assoc(INFO_POS, (ACell)info));
        }
        return this;
    }

    public static Result fromContext(Context ctx) {
        Object rval = ctx.isExceptional() ? ctx.getExceptional().getMessage() : ctx.getResult();
        return Result.create(null, rval, ctx.getErrorCode(), null);
    }

    public Result withID(ACell id) {
        return this.withValues((AVector)this.values.assoc(ID_POS, id));
    }

    @Override
    public byte getTag() {
        return -83;
    }

    @Override
    public RecordFormat getFormat() {
        return RESULT_FORMAT;
    }

    public static Result fromException(Throwable e) {
        if (e instanceof TimeoutException) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            return Result.create(null, ErrorCodes.TIMEOUT, Strings.create(msg));
        }
        return Result.create(null, ErrorCodes.EXCEPTION, Strings.create(e.getMessage()));
    }
}

