/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;

public class Receipt
extends ARecord {
    private static final Keyword[] RECEIPT_KEYS = new Keyword[]{Keywords.RESULT, Keywords.ERROR, Keywords.LOG};
    private static final RecordFormat FORMAT = RecordFormat.of(RECEIPT_KEYS);
    private static final long RECEIPT_LENGTH = RECEIPT_KEYS.length;
    private static final AVector<AVector<ACell>> EMPTY_LOG = Vectors.empty();
    private final boolean isError;
    private final ACell result;
    private final AVector<AVector<ACell>> log;

    protected Receipt(boolean error, ACell value, AVector<AVector<ACell>> log) {
        super(RECEIPT_LENGTH);
        this.isError = error;
        this.result = value;
        this.log = log;
    }

    public static Receipt create(ACell result) {
        return new Receipt(false, result, null);
    }

    public static Receipt create(boolean isError, ACell value, AVector<AVector<ACell>> log) {
        if (log != null && log.isEmpty()) {
            log = null;
        }
        return new Receipt(isError, value, log);
    }

    public static Receipt createError(ACell errorCode) {
        return new Receipt(true, errorCode, null);
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.RESULT.equals(k)) {
            return this.getResult();
        }
        if (Keywords.ERROR.equals(k)) {
            return this.getErrorCode();
        }
        if (Keywords.LOG.equals(k)) {
            return this.getLog();
        }
        return null;
    }

    private AVector<AVector<ACell>> getLog() {
        return this.log == null ? EMPTY_LOG : this.log;
    }

    public ACell getErrorCode() {
        if (!this.isError) {
            return null;
        }
        return this.result;
    }

    public ACell getResult() {
        if (this.isError) {
            return null;
        }
        return this.result;
    }

    @Override
    public byte getTag() {
        int tag = -40 + (this.isError ? 1 : 0) + (this.log == null ? 0 : 2);
        return (byte)tag;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.result != null) {
            if (!this.result.isCVMValue()) {
                throw new InvalidDataException("Receipt Result must be CVM value", this);
            }
            this.result.validateCell();
        }
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof Receipt)) {
            return false;
        }
        return this.equals((Receipt)a);
    }

    public boolean equals(Receipt a) {
        if (a == this) {
            return true;
        }
        if (this.isError != a.isError) {
            return false;
        }
        if (!Cells.equals(this.result, a.result)) {
            return false;
        }
        return Cells.equals(this.log, a.log);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos] = this.getTag();
        return this.encodeRaw(bs, pos + 1);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.result);
        if (this.log != null) {
            pos = this.log.encode(bs, pos);
        }
        return pos;
    }

    public static Receipt read(byte tag, Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        boolean isError = (tag & 1) != 0;
        boolean hasLog = (tag & 2) != 0;
        Object result = Format.read(b, epos);
        epos += Format.getEncodingLength(result);
        AVector<AVector<ACell>> log = null;
        if (hasLog) {
            log = Vectors.read(b, epos);
            if (log == null || log.isEmpty()) {
                throw new BadFormatException("Expected non-empty log");
            }
            epos += Format.getEncodingLength(log);
        }
        Receipt receipt = new Receipt(isError, (ACell)result, log);
        receipt.attachEncoding(b.slice(pos, epos));
        return receipt;
    }

    @Override
    public Receipt updateRefs(IRefFunction func) {
        ACell newResult = Ref.update(this.result, func);
        AVector<AVector<ACell>> newLog = Ref.update(this.log, func);
        if (this.log == newLog && this.result == newResult) {
            return this;
        }
        return new Receipt(this.isError, newResult, newLog);
    }

    @Override
    public int getRefCount() {
        return Cells.refCount(this.result) + Cells.refCount(this.log);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int rr = Cells.refCount(this.result);
        if (i < rr) {
            if (this.result == null) {
                throw new IndexOutOfBoundsException("Negative ref index");
            }
            return this.result.getRef(i);
        }
        if (this.log == null) {
            throw new IndexOutOfBoundsException("Excessive ref index");
        }
        return this.log.getRef(i - rr);
    }

    public boolean isError() {
        return this.isError;
    }
}

