/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;

public class Order
extends ARecord {
    private final Ref<AVector<SignedData<Block>>> blocks;
    private final long[] consensusPoints;
    private final long timestamp;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.BLOCKS, Keywords.CONSENSUS_POINT, Keywords.PROPOSAL_POINT, Keywords.TIMESTAMP};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    private static final long[] EMPTY_CONSENSUS_ARRAY = new long[4];

    private Order(Ref<AVector<SignedData<Block>>> blocks, long[] consensusPoints, long timestamp) {
        super(FORMAT.count());
        this.blocks = blocks;
        this.consensusPoints = consensusPoints;
        this.timestamp = timestamp;
    }

    private static Order create(Ref<AVector<SignedData<Block>>> blocks, long proposalPoint, long consensusPoint, long timestamp) {
        long[] consensusPoints = new long[4];
        consensusPoints[0] = blocks.getValue().count();
        consensusPoints[1] = proposalPoint;
        consensusPoints[2] = consensusPoint;
        return new Order(blocks, consensusPoints, timestamp);
    }

    public static Order create(long proposalPoint, long consensusPoint, SignedData<Block> ... blocks) {
        return Order.create(Vectors.of(blocks).getRef(), proposalPoint, consensusPoint, 0L);
    }

    public static Order create() {
        return new Order(Vectors.empty().getRef(), EMPTY_CONSENSUS_ARRAY, 0L);
    }

    private byte getRecordTag() {
        return -84;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getRecordTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.blocks.encode(bs, pos);
        for (int level = 1; level < 4; ++level) {
            pos = Format.writeVLCLong(bs, pos, this.consensusPoints[level]);
        }
        pos = Format.writeVLCLong(bs, pos, this.timestamp);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.blocks.estimatedEncodingSize() + 30;
    }

    public static Order read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<AVector<SignedData<Block>>> blocks = Format.readRef(b, epos);
        if (blocks == null) {
            throw new BadFormatException("Null blocks in Order!");
        }
        epos = (int)((long)epos + blocks.getEncodingLength());
        long[] cps = new long[4];
        long last = Long.MAX_VALUE;
        for (int level = 1; level < 4; ++level) {
            long pp;
            cps[level] = pp = Format.readVLCLong(b, epos);
            epos += Format.getVLCLength(pp);
            if (pp > last) {
                throw new BadFormatException("Consensus point [" + pp + "] before previous value [" + last + "] at level " + level);
            }
            last = pp;
        }
        long ts = Format.readVLCLong(b, epos);
        Order result = new Order(blocks, cps, ts);
        result.attachEncoding(b.slice(pos, epos += Format.getVLCLength(ts)));
        return result;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    public boolean checkConsistent(Order bc) {
        long commonPrefix = this.getBlocks().commonPrefixLength(bc.getBlocks());
        return commonPrefix >= this.getConsensusPoint();
    }

    public long getConsensusPoint(int level) {
        if (level == 0) {
            return this.blocks.getValue().count();
        }
        return this.consensusPoints[level];
    }

    public long[] getConsensusPoints() {
        long[] result = (long[])this.consensusPoints.clone();
        result[0] = this.getBlockCount();
        return result;
    }

    public long getProposalPoint() {
        return this.consensusPoints[1];
    }

    public long getConsensusPoint() {
        return this.consensusPoints[2];
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AVector<SignedData<Block>> getBlocks() {
        return this.blocks.getValue();
    }

    public SignedData<Block> getBlock(long i) {
        return this.getBlocks().get(i);
    }

    public Order append(SignedData<Block> block) {
        AVector<SignedData<Block>> newBlocks = this.getBlocks().append(block);
        return this.withBlocks(newBlocks);
    }

    public Order withBlocks(AVector<SignedData<Block>> newBlocks) {
        if (this.blocks.getValue() == newBlocks) {
            return this;
        }
        long nblocks = newBlocks.count();
        long newProposalPoint = Math.min(nblocks, this.getProposalPoint());
        long newConsensusPoint = Math.min(nblocks, this.getConsensusPoint());
        return Order.create(newBlocks.getRef(), newProposalPoint, newConsensusPoint, this.timestamp);
    }

    public Order withTimestamp(long newTimestamp) {
        if (this.timestamp == newTimestamp) {
            return this;
        }
        return new Order(this.blocks, this.consensusPoints, newTimestamp);
    }

    public Order withConsensusPoint(int level, long newPosition) {
        if (level == 0) {
            return this;
        }
        if (this.consensusPoints[level] == newPosition) {
            return this;
        }
        long[] cps = (long[])this.consensusPoints.clone();
        cps[0] = this.getBlockCount();
        cps[level] = newPosition;
        return new Order(this.blocks, cps, this.timestamp);
    }

    public Order withConsensusPoints(long[] newPositions) {
        long[] cps = (long[])newPositions.clone();
        cps[0] = this.getBlockCount();
        return new Order(this.blocks, cps, this.timestamp);
    }

    public long getBlockCount() {
        return this.getBlocks().count();
    }

    public Order withoutConsenus() {
        return new Order(this.blocks, EMPTY_CONSENSUS_ARRAY, this.timestamp);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.blocks.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i == 0) {
            return this.blocks;
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public byte getTag() {
        return -84;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.BLOCKS.equals(key)) {
            return this.getBlocks();
        }
        if (Keywords.CONSENSUS_POINT.equals(key)) {
            return CVMLong.create(this.getConsensusPoint());
        }
        if (Keywords.PROPOSAL_POINT.equals(key)) {
            return CVMLong.create(this.getProposalPoint());
        }
        if (Keywords.TIMESTAMP.equals(key)) {
            return CVMLong.create(this.timestamp);
        }
        return null;
    }

    @Override
    public Order updateRefs(IRefFunction func) {
        Ref<AVector<SignedData<Block>>> newBlocks = func.apply(this.blocks);
        if (this.blocks == newBlocks) {
            return this;
        }
        return new Order(newBlocks, this.consensusPoints, this.timestamp);
    }

    public boolean consensusEquals(Order b) {
        if (b == null) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            if (this.getConsensusPoint(i) == b.getConsensusPoint(i)) continue;
            return false;
        }
        return this.blocks.equals(b.blocks);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }

    @Override
    public boolean equals(ACell o) {
        return ACell.genericEquals(this, o);
    }
}

