/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.util.Comparator;
import java.util.List;

public final class Block
extends ARecord {
    private final long timestamp;
    private final AVector<SignedData<ATransaction>> transactions;
    private static final Keyword[] BLOCK_KEYS = new Keyword[]{Keywords.TIMESTAMP, Keywords.TRANSACTIONS};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCK_KEYS);
    static final Comparator<SignedData<Block>> TIMESTAMP_COMPARATOR = new Comparator<SignedData<Block>>(){

        @Override
        public int compare(SignedData<Block> a, SignedData<Block> b) {
            int sig = Long.compare(a.getValue().getTimeStamp(), b.getValue().getTimeStamp());
            return sig;
        }
    };

    private Block(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        super(FORMAT.count());
        this.timestamp = timestamp;
        this.transactions = transactions;
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.TIMESTAMP.equals(k)) {
            return CVMLong.create(this.timestamp);
        }
        if (Keywords.TRANSACTIONS.equals(k)) {
            return this.transactions;
        }
        return null;
    }

    @Override
    public Block updateRefs(IRefFunction func) {
        ACell newTransactions = this.transactions.updateRefs(func);
        if (this.transactions == newTransactions) {
            return this;
        }
        return new Block(this.timestamp, (AVector<SignedData<ATransaction>>)newTransactions);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public static Block create(long timestamp, List<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, Vectors.create(transactions));
    }

    public static Block create(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, transactions);
    }

    @SafeVarargs
    public static Block of(long timestamp, SignedData<ATransaction> ... transactions) {
        return new Block(timestamp, Vectors.of(transactions));
    }

    public int length() {
        return Utils.checkedInt(this.transactions.count());
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.timestamp);
        pos = Format.write(bs, pos, this.transactions);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + this.transactions.estimatedEncodingSize() + 32;
    }

    public static Block read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        long timestamp = b.longAt(epos);
        AVector transactions = (AVector)Format.read(b, epos += 8);
        Block result = Block.create(timestamp, transactions);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(transactions)));
        return result;
    }

    public AVector<SignedData<ATransaction>> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isCanonical() {
        return this.transactions.isCanonical();
    }

    @Override
    public byte getTag() {
        return -85;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.transactions.validateCell();
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof Block)) {
            return false;
        }
        return this.equals((Block)a);
    }

    public boolean equals(Block a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        return Cells.equals(this.transactions, a.transactions);
    }

    @Override
    public boolean isCVMValue() {
        return false;
    }

    @Override
    public int getRefCount() {
        return this.transactions.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.transactions.getRef(i);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

