/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.Constants;
import convex.core.Order;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AIndex;
import convex.core.data.ARecord;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Belief
extends ARecord {
    private static final RecordFormat BELIEF_FORMAT = RecordFormat.of(Keywords.ORDERS);
    private static final Index<AccountKey, SignedData<Order>> EMPTY_ORDERS = Index.none();
    private final Index<AccountKey, SignedData<Order>> orders;

    Belief(Index<AccountKey, SignedData<Order>> orders) {
        super(BELIEF_FORMAT.count());
        this.orders = orders;
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.ORDERS.equals(k)) {
            return this.orders;
        }
        return null;
    }

    @Override
    public Belief updateRefs(IRefFunction func) {
        ACell newOrders = this.orders.updateRefs(func);
        if (this.orders == newOrders) {
            return this;
        }
        return new Belief((Index<AccountKey, SignedData<Order>>)newOrders);
    }

    public static Belief initial() {
        return Belief.create(EMPTY_ORDERS);
    }

    public static Belief create(AKeyPair kp, Order order) {
        Index<AccountKey, SignedData<Order>> orders = Index.of((Object)kp.getAccountKey(), kp.signData(order));
        return Belief.create(orders);
    }

    private static Belief create(Index<AccountKey, SignedData<Order>> orders, long timestamp) {
        return new Belief(orders);
    }

    public static Belief create(SignedData<Order> ... orders) {
        AIndex newOrders = EMPTY_ORDERS;
        for (SignedData<Order> so : orders) {
            newOrders = newOrders.assoc(so.getAccountKey(), so);
        }
        return new Belief((Index<AccountKey, SignedData<Order>>)newOrders);
    }

    public static Belief create(HashMap<AccountKey, SignedData<Order>> orderMap) {
        Index orders = (Index)Index.create(orderMap);
        return new Belief(orders);
    }

    private static Belief create(Index<AccountKey, SignedData<Order>> orders) {
        return Belief.create(orders, Constants.INITIAL_TIMESTAMP);
    }

    public static Belief createSingleOrder(AKeyPair kp) {
        AccountKey address = kp.getAccountKey();
        SignedData<Order> order = kp.signData(Order.create());
        return Belief.create(Index.of((Object)address, order));
    }

    public Belief withOrders(Index<AccountKey, SignedData<Order>> newOrders) {
        if (newOrders == this.orders) {
            return this;
        }
        return Belief.create(newOrders);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.orders.estimatedEncodingSize() + 12;
    }

    public static Belief read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Index orders = (Index)Format.read(b, epos);
        if (orders == null) {
            throw new BadFormatException("Null orders in Belief");
        }
        Belief result = new Belief(orders);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(orders)));
        return result;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.orders);
        return pos;
    }

    @Override
    public byte getTag() {
        return -86;
    }

    public Order getOrder(AccountKey address) {
        SignedData<Order> sc = this.orders.get(address);
        if (sc == null) {
            return null;
        }
        return sc.getValue();
    }

    public Index<AccountKey, SignedData<Order>> getOrders() {
        return this.orders;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.orders == null) {
            throw new InvalidDataException("Null orders", this);
        }
        this.orders.validateCell();
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof Belief)) {
            return false;
        }
        Belief as = (Belief)a;
        return this.equals(as);
    }

    public boolean equals(Belief a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        return this.orders.equals(a.orders);
    }

    @Override
    public int getRefCount() {
        return this.orders.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.orders.getRef(i);
    }

    public HashMap<AccountKey, SignedData<Order>> getOrdersHashMap() {
        int n = this.orders.size();
        HashMap<AccountKey, SignedData<Order>> hm = new HashMap<AccountKey, SignedData<Order>>(n);
        for (int i = 0; i < n; ++i) {
            MapEntry<AccountKey, SignedData<Order>> entry = this.orders.entryAt(i);
            AccountKey key = RT.ensureAccountKey((ACell)entry.getKey());
            hm.put(key, (SignedData)entry.getValue());
        }
        return hm;
    }

    @Override
    public RecordFormat getFormat() {
        return BELIEF_FORMAT;
    }

    public static Collection<SignedData<Order>> extractOrders(ACell payload) {
        ArrayList<SignedData<Order>> result = new ArrayList<SignedData<Order>>();
        if (payload instanceof SignedData) {
            SignedData sd = (SignedData)payload;
            if (sd.getValue() instanceof Order) {
                result.add(sd);
            }
        } else if (payload instanceof Belief) {
            Belief b = (Belief)payload;
            Index<AccountKey, SignedData<Order>> porders = b.getOrders();
            int n = porders.size();
            for (int i = 0; i < n; ++i) {
                result.add((SignedData)porders.entryAt(i).getValue());
            }
        }
        return result;
    }

    public Belief proposeBlock(AKeyPair kp, SignedData<Block> signedBlock) {
        AccountKey peerKey = kp.getAccountKey();
        Index<AccountKey, SignedData<Order>> orders = this.getOrders();
        SignedData<Order> mySO = orders.get(peerKey);
        Order myOrder = mySO == null ? Order.create() : mySO.getValue();
        Order newOrder = myOrder.append(signedBlock);
        SignedData<Order> newSignedOrder = kp.signData(newOrder);
        AIndex newOrders = orders.assoc(peerKey, newSignedOrder);
        Belief newBelief = this.withOrders((Index<AccountKey, SignedData<Order>>)newOrders);
        return newBelief;
    }
}

