/*
 * Decompiled with CFR 0.152.
 */
package etch;

import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefSoft;
import convex.core.util.Counters;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import etch.EtchStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Etch {
    private static final int KEY_SIZE = 32;
    private static final int MAX_LEVEL = 60;
    private static final int LABEL_SIZE = 9;
    private static final int LENGTH_SIZE = 2;
    private static final int POINTER_SIZE = 8;
    private static final long MAX_REGION_SIZE = 0x40000000L;
    private static final long REGION_MARGIN = 65536L;
    private static final byte[] MAGIC_NUMBER = Utils.hexToBytes("e7c6");
    private static final int SIZE_HEADER_MAGIC = 2;
    private static final int SIZE_HEADER_FILESIZE = 8;
    private static final int SIZE_HEADER_ROOT = 32;
    private static final int SIZE_HEADER = 42;
    protected static final long OFFSET_FILE_SIZE = 2L;
    protected static final long OFFSET_ROOT_HASH = 10L;
    private static final long INDEX_START = 42L;
    private static final long TYPE_MASK = -4611686018427387904L;
    private static final long PTR_PLAIN = 0L;
    private static final long PTR_INDEX = 0x4000000000000000L;
    private static final long PTR_START = Long.MIN_VALUE;
    private static final long PTR_CHAIN = -4611686018427387904L;
    private static final Logger log = LoggerFactory.getLogger((String)Etch.class.getName());
    private final ThreadLocal<byte[]> tempArray = new ThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[2048];
        }
    };
    private static long tempIndex = 0L;
    private final File file;
    private final String fileName;
    private final RandomAccessFile data;
    private final ArrayList<MappedByteBuffer> regionMap = new ArrayList();
    private long dataLength = 0L;
    private boolean BUILD_CHAINS = true;
    private EtchStore store;

    private Etch(File dataFile) throws IOException {
        this.file = dataFile;
        if (!dataFile.exists()) {
            dataFile.createNewFile();
        }
        this.data = new RandomAccessFile(dataFile, "rw");
        this.fileName = dataFile.getCanonicalPath();
        FileChannel fileChannel = this.data.getChannel();
        FileLock lock = fileChannel.tryLock();
        if (lock == null) {
            log.error("Unable to obtain lock on file: {}", (Object)dataFile);
            throw new IOException("File lock failed");
        }
        if (dataFile.length() == 0L) {
            MappedByteBuffer mbb = this.seekMap(0L);
            mbb.put(MAGIC_NUMBER);
            int headerZeros = 40;
            byte[] temp = new byte[headerZeros];
            mbb.put(temp, 0, headerZeros);
            this.dataLength = 42L;
            mbb = this.seekMap(42L);
            long indexStart = this.appendNewIndexBlock(0);
            assert (indexStart == 42L);
            mbb = this.seekMap(2L);
            mbb.putLong(this.dataLength);
        } else {
            long length;
            MappedByteBuffer mbb = this.seekMap(0L);
            byte[] check = new byte[2];
            mbb.get(check);
            if (!Arrays.equals(MAGIC_NUMBER, check)) {
                throw new IOException("Bad magic number! Probably not an Etch file: " + dataFile);
            }
            this.dataLength = length = mbb.getLong();
        }
        Shutdown.addHook(100, new Runnable(){

            @Override
            public void run() {
                Etch.this.close();
            }
        });
    }

    public static Etch createTempEtch() throws IOException {
        Etch newEtch = Etch.createTempEtch("etch-" + tempIndex);
        ++tempIndex;
        return newEtch;
    }

    public static Etch createTempEtch(String prefix) throws IOException {
        File data = File.createTempFile(prefix + "-", null);
        data.deleteOnExit();
        return new Etch(data);
    }

    public static Etch create(File file) throws IOException {
        Etch etch = new Etch(file);
        log.debug("Etch created on file: {} with data length: {}", (Object)file, (Object)etch.dataLength);
        return etch;
    }

    private MappedByteBuffer seekMap(long position) throws IOException {
        if ((position = this.slotPointer(position)) < 0L || position > this.dataLength) {
            throw new Error("Seek out of range in Etch file: position=" + Utils.toHexString(position) + " dataLength=" + Utils.toHexString(this.dataLength) + " file=" + this.file.getName());
        }
        MappedByteBuffer mbb = (MappedByteBuffer)((ByteBuffer)this.getInternalBuffer(position)).duplicate();
        mbb.position(Utils.checkedInt(position % 0x40000000L));
        return mbb;
    }

    private MappedByteBuffer getInternalBuffer(long position) throws IOException {
        int regionMapSize;
        MappedByteBuffer mbb;
        int regionIndex = Utils.checkedInt(position / 0x40000000L);
        MappedByteBuffer mappedByteBuffer = mbb = regionIndex < (regionMapSize = this.regionMap.size()) ? this.regionMap.get(regionIndex) : null;
        if (mbb == null || (long)mbb.capacity() + (long)regionIndex * 0x40000000L < position + 65536L) {
            mbb = this.createBuffer(regionIndex);
        }
        return mbb;
    }

    private synchronized MappedByteBuffer createBuffer(int regionIndex) throws IOException {
        int length;
        while (this.regionMap.size() <= regionIndex) {
            this.regionMap.add(null);
        }
        long pos = (long)regionIndex * 0x40000000L;
        if (regionIndex == 0) {
            length = 65536;
            while ((long)length < 0x40000000L && pos + (long)length < this.dataLength + 65536L) {
                length *= 2;
            }
        } else {
            length = 0x40000000;
        }
        length = (int)((long)length + 65536L);
        MappedByteBuffer mbb = this.data.getChannel().map(FileChannel.MapMode.READ_WRITE, pos, length);
        this.regionMap.set(regionIndex, mbb);
        return mbb;
    }

    public synchronized Ref<ACell> write(AArrayBlob key, Ref<ACell> value) throws IOException {
        return this.write(key, 0, value, 42L);
    }

    private Ref<ACell> write(AArrayBlob key, int level, Ref<ACell> ref, long indexPosition) throws IOException {
        if (level >= 60) {
            throw new Error("Max Level exceeded for key: " + key);
        }
        int isize = this.indexSize(level);
        int mask = isize - 1;
        int digit = this.getDigit(key, level);
        long slotValue = this.readSlot(indexPosition, digit);
        long type = this.slotType(slotValue);
        if (slotValue == 0L) {
            return this.writeNewData(indexPosition, digit, key, ref, 0L);
        }
        if (type == 0x4000000000000000L) {
            long newIndexPosition = this.slotPointer(slotValue);
            return this.write(key, level + 1, ref, newIndexPosition);
        }
        if (type == 0L) {
            if (this.checkMatchingKey(key, slotValue)) {
                return this.updateInPlace(slotValue, ref);
            }
            int nextDigit = digit + 1;
            long nextSlotValue = this.readSlot(indexPosition, nextDigit);
            if (this.BUILD_CHAINS && nextSlotValue == 0L) {
                this.writeSlot(indexPosition, digit, slotValue | Long.MIN_VALUE);
                long newDataPointer = this.appendData(key, ref);
                this.writeSlot(indexPosition, nextDigit, newDataPointer | 0xC000000000000000L);
                return ref;
            }
            int nextLevel = level + 1;
            byte[] temp = this.tempArray.get();
            int nextDigitOfCollided = this.getDigit(Blob.wrap(temp, 0, 32), nextLevel);
            long newIndexPosition = this.appendLeafIndex(nextLevel, nextDigitOfCollided, slotValue);
            this.writeSlot(indexPosition, digit, newIndexPosition | 0x4000000000000000L);
            return this.write(key, nextLevel, ref, newIndexPosition);
        }
        if (type == Long.MIN_VALUE) {
            int i;
            if (this.checkMatchingKey(key, slotValue)) {
                return this.updateInPlace(slotValue, ref);
            }
            for (i = 1; i < isize; ++i) {
                int ix = digit + i & mask;
                slotValue = this.readSlot(indexPosition, ix);
                if (slotValue == 0L) {
                    return this.writeNewData(indexPosition, ix, key, ref, -4611686018427387904L);
                }
                if (this.slotType(slotValue) != -4611686018427387904L) break;
                if (!this.checkMatchingKey(key, slotValue)) continue;
                return this.updateInPlace(slotValue, ref);
            }
            int nextLevel = level + 1;
            long newDataPointer = this.appendData(key, ref);
            int nextDigit = this.getDigit(key, nextLevel);
            long newIndexPos = this.appendLeafIndex(nextLevel, nextDigit, newDataPointer);
            for (int j = 0; j < i; ++j) {
                int movingDigit = digit + j & mask;
                long movingSlotValue = this.readSlot(indexPosition, movingDigit);
                long dp = this.slotPointer(movingSlotValue);
                this.writeExistingData(newIndexPos, nextLevel, dp);
                if (j == 0) continue;
                this.writeSlot(indexPosition, movingDigit, 0L);
            }
            this.writeSlot(indexPosition, digit, newIndexPos | 0x4000000000000000L);
            return ref;
        }
        if (type == -4611686018427387904L) {
            int chainStartDigit = this.seekChainStart(indexPosition, digit, isize);
            if (chainStartDigit == digit) {
                throw new Error("Can't start chain at this digit? " + digit);
            }
            int chainEndDigit = this.seekChainEnd(indexPosition, digit, isize);
            int nextLevel = level + 1;
            int n = chainStartDigit == chainEndDigit ? isize : chainEndDigit - chainStartDigit & mask;
            long newIndexPos = this.appendNewIndexBlock(nextLevel);
            for (int j = 0; j < n; ++j) {
                int movingDigit = chainStartDigit + j & mask;
                long movingSlotValue = this.readSlot(indexPosition, movingDigit);
                long dp = this.slotPointer(movingSlotValue);
                this.writeExistingData(newIndexPos, nextLevel, dp);
                if (j == 0) continue;
                this.writeSlot(indexPosition, movingDigit, 0L);
            }
            this.writeSlot(indexPosition, chainStartDigit, newIndexPos | 0x4000000000000000L);
            return this.writeNewData(indexPosition, digit, key, ref, 0L);
        }
        throw new Error("Unexpected type: " + type);
    }

    private int seekChainStart(long indexPosition, int digit, int isize) throws IOException {
        int mask = isize - 1;
        int i = (digit &= mask) - 1 & mask;
        while (i != digit) {
            long slotValue = this.readSlot(indexPosition, i);
            if (this.slotType(slotValue) == Long.MIN_VALUE) {
                return i;
            }
            i = i - 1 & mask;
        }
        throw new Error("Infinite chain?");
    }

    private int seekChainEnd(long indexPosition, int digit, int isize) throws IOException {
        int mask = isize - 1;
        int i = (digit &= mask) + 1 & mask;
        while (i != digit) {
            long slotValue = this.readSlot(indexPosition, i);
            if (this.slotType(slotValue) != -4611686018427387904L) {
                return i;
            }
            i = i + 1 & mask;
        }
        throw new Error("Infinite chain?");
    }

    private void writeExistingData(long indexPosition, int level, long dp) throws IOException {
        int isize = this.indexSize(level);
        int mask = isize - 1;
        int digit = this.getDigit(dp, level);
        long currentSlot = this.readSlot(indexPosition, digit);
        long type = currentSlot & 0xC000000000000000L;
        if (currentSlot == 0L) {
            this.writeSlot(indexPosition, digit, dp);
        } else if (type == 0x4000000000000000L) {
            this.writeExistingData(this.slotPointer(currentSlot), level + 1, dp);
        } else if (type == 0L) {
            int newLevel = level + 1;
            long newIndexPosition = this.appendNewIndexBlock(newLevel);
            this.writeExistingData(newIndexPosition, newLevel, dp);
            this.writeExistingData(newIndexPosition, newLevel, currentSlot);
            this.writeSlot(indexPosition, digit, newIndexPosition | 0x4000000000000000L);
        } else {
            throw new Error("Unexpected type: " + type);
        }
    }

    protected Blob readBlob(long pointer, int length) throws IOException {
        MappedByteBuffer mbb = this.seekMap(pointer);
        byte[] bs = new byte[length];
        mbb.get(bs);
        return Blob.wrap(bs);
    }

    private long slotType(long slotValue) {
        return slotValue & 0xC000000000000000L;
    }

    protected void truncateFile() throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.file, true);){
            FileChannel outChan = fos.getChannel();
            outChan.truncate(this.dataLength);
        }
    }

    synchronized void close() {
        if (!this.data.getChannel().isOpen()) {
            return;
        }
        try {
            this.writeDataLength();
            this.flush();
            this.regionMap.clear();
            System.gc();
            this.data.close();
            log.debug("Etch closed on file: " + this.getFileName() + " with data length: " + this.dataLength);
        }
        catch (IOException e) {
            log.error("Error closing Etch file: " + this.file);
        }
    }

    public long getDataLength() {
        return this.dataLength;
    }

    protected void writeDataLength() throws IOException {
        MappedByteBuffer mbb = this.seekMap(2L);
        mbb.putLong(this.dataLength);
        mbb = null;
    }

    private long slotPointer(long slotValue) {
        return slotValue & 0x3FFFFFFFFFFFFFFFL;
    }

    private boolean checkMatchingKey(AArrayBlob key, long dataPointer) throws IOException {
        long dataPosition = dataPointer & 0x3FFFFFFFFFFFFFFFL;
        MappedByteBuffer mbb = this.seekMap(dataPosition);
        byte[] temp = this.tempArray.get();
        mbb.get(temp, 0, 32);
        return key.equalsBytes(temp, 0);
    }

    private long appendLeafIndex(int level, int digit, long dataPointer) throws IOException {
        assert (level > 0);
        int isize = this.indexSize(level);
        int mask = isize - 1;
        int indexBlockLength = 8 * isize;
        long position = this.dataLength;
        byte[] temp = this.tempArray.get();
        Arrays.fill(temp, 0, indexBlockLength, (byte)0);
        int ix = 8 * (digit &= mask);
        Utils.writeLong(temp, ix, dataPointer);
        MappedByteBuffer mbb = this.seekMap(position);
        mbb.put(temp, 0, indexBlockLength);
        this.setDataLength(position + (long)indexBlockLength);
        return position;
    }

    public RefSoft<ACell> read(AArrayBlob key) throws IOException {
        ++Counters.etchRead;
        long pointer = this.seekPosition(key);
        if (pointer < 0L) {
            ++Counters.etchMiss;
            return null;
        }
        MappedByteBuffer mbb = this.seekMap(pointer + 32L);
        byte flagByte = mbb.get();
        long memorySize = mbb.getLong();
        short length = mbb.getShort();
        byte[] bs = new byte[length];
        mbb.get(bs);
        Blob encoding = Blob.wrap(bs);
        try {
            Hash hash = Hash.wrap(key);
            ACell cell = this.store.decode(encoding);
            cell.getEncoding().attachContentHash(hash);
            if (memorySize > 0L) {
                cell.attachMemorySize(memorySize);
            }
            RefSoft<ACell> ref = RefSoft.create(this.store, cell, flagByte);
            cell.attachRef(ref);
            return ref;
        }
        catch (Exception e) {
            throw new Error("Failed to read data in etch store: " + encoding.toHexString() + " flags = " + Utils.toHexString(flagByte) + " length =" + length + " pointer = " + Utils.toHexString(pointer) + " memorySize=" + memorySize, e);
        }
    }

    public synchronized void flush() throws IOException {
        for (MappedByteBuffer mbb : this.regionMap) {
            if (mbb == null) continue;
            mbb.force();
        }
        this.data.getChannel().force(false);
    }

    private long seekPosition(AArrayBlob key) throws IOException {
        return this.seekPosition(key, 0, 42L);
    }

    private long readSlot(long indexPosition, int digit) throws IOException {
        long pointerIndex = indexPosition + (long)(8 * digit);
        MappedByteBuffer mbb = this.seekMap(pointerIndex);
        long pointer = mbb.getLong();
        return pointer;
    }

    private Ref<ACell> writeNewData(long indexPosition, int digit, AArrayBlob key, Ref<ACell> value, long type) throws IOException {
        long newDataPointer = this.appendData(key, value) | type;
        this.writeSlot(indexPosition, digit, newDataPointer);
        return value;
    }

    private Ref<ACell> updateInPlace(long position, Ref<ACell> ref) throws IOException {
        MappedByteBuffer mbb = this.seekMap(position + 32L);
        byte currentFlags = mbb.get();
        int newFlags = Ref.mergeFlags(currentFlags, ref.getFlags());
        long currentSize = mbb.getLong();
        if (currentFlags == newFlags) {
            return ref;
        }
        mbb = this.seekMap(position + 32L);
        mbb.put((byte)newFlags);
        if (currentSize == 0L && (newFlags & 0xF) >= 2) {
            mbb.putLong(ref.getValue().getMemorySize());
        }
        return ref.withFlags(newFlags);
    }

    private void writeSlot(long indexPosition, int digit, long slotValue) throws IOException {
        long position = indexPosition + (long)(digit * 8);
        MappedByteBuffer mbb = this.seekMap(position);
        mbb.putLong(slotValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long seekPosition(AArrayBlob key, int level, long indexPosition) throws IOException {
        if (level >= 60) {
            throw new Error("Etch index level exceeded for key: " + key);
        }
        int isize = this.indexSize(level);
        int mask = isize - 1;
        int digit = this.getDigit(key, level);
        long slotValue = this.readSlot(indexPosition, digit);
        long type = slotValue & 0xC000000000000000L;
        if (slotValue == 0L) {
            return -1L;
        }
        if (type == 0x4000000000000000L) {
            long newIndexPosition = this.slotPointer(slotValue);
            return this.seekPosition(key, level + 1, newIndexPosition);
        }
        if (type == 0L) {
            if (this.checkMatchingKey(key, slotValue)) {
                return slotValue;
            }
            return -1L;
        }
        if (type == -4611686018427387904L) {
            return -1L;
        }
        if (type == Long.MIN_VALUE) {
            Etch etch = this;
            synchronized (etch) {
                int i = 0;
                while (i < isize) {
                    long ptr = slotValue & 0x3FFFFFFFFFFFFFFFL;
                    if (this.checkMatchingKey(key, ptr)) {
                        return ptr;
                    }
                    if ((type = (slotValue = this.readSlot(indexPosition, digit + ++i & mask)) & 0xC000000000000000L) == -4611686018427387904L) continue;
                    return -1L;
                }
            }
            return -1L;
        }
        throw new Error("Shouldn't be possible!");
    }

    private int getDigit(AArrayBlob key, int level) {
        if (level == 0) {
            return key.shortAt(0L) & 0xFFFF;
        }
        if (level == 1) {
            return key.byteAt(2L) & 0xFF;
        }
        int bi = (level + 4) / 2;
        boolean hi = (level & 1) == 0;
        int v = key.byteAt(bi);
        return (hi ? v >> 4 : v) & 0xF;
    }

    private int getDigit(long dp, int level) throws IOException {
        if (level == 0) {
            MappedByteBuffer mbb = this.seekMap(dp);
            return mbb.getShort() & 0xFFFF;
        }
        if (level == 1) {
            MappedByteBuffer mbb = this.seekMap(dp + (long)(level + 1));
            return mbb.get() & 0xFF;
        }
        int bi = (level + 4) / 2;
        boolean hi = (level & 1) == 0;
        MappedByteBuffer mbb = this.seekMap(dp + (long)bi);
        int v = mbb.get();
        return (hi ? v >> 4 : v) & 0xF;
    }

    public int indexSize(int level) {
        if (level == 0) {
            return 65536;
        }
        if (level == 1) {
            return 256;
        }
        return 16;
    }

    private long appendNewIndexBlock(int level) throws IOException {
        if (level >= 60) {
            throw new Error("Overflowing key size - key collision?");
        }
        int isize = this.indexSize(level);
        int sizeBytes = isize * 8;
        long position = this.dataLength;
        byte[] temp = this.tempArray.get();
        int tlen = temp.length;
        MappedByteBuffer mbb = null;
        this.setDataLength(position + (long)sizeBytes);
        Arrays.fill(temp, 0, Math.min(sizeBytes, tlen), (byte)0);
        for (int ix = 0; ix < sizeBytes; ix += tlen) {
            mbb = this.seekMap(position + (long)ix);
            mbb.put(temp, 0, Math.min(sizeBytes - ix, tlen));
        }
        return position;
    }

    private long appendData(AArrayBlob key, Ref<ACell> ref) throws IOException {
        assert (key.count() == 32L);
        ++Counters.etchWrite;
        ACell cell = ref.getValue();
        Blob encoding = cell.getEncoding();
        int status = ref.getStatus();
        long memorySize = 0L;
        if (status >= 2) {
            memorySize = cell.getMemorySize();
        }
        long position = this.dataLength;
        MappedByteBuffer mbb = this.seekMap(position);
        mbb.put(key.getInternalArray(), key.getInternalOffset(), 32);
        int flags = ref.flagsWithStatus(Math.max(ref.getStatus(), 1));
        mbb.put((byte)flags);
        mbb.putLong(memorySize);
        short length = Utils.checkedShort(encoding.count());
        if (length == 0) {
            throw new Error("Etch trying to write zero length encoding for: " + Utils.getClassName(cell));
        }
        mbb.putShort(length);
        mbb.put(encoding.getInternalArray(), encoding.getInternalOffset(), length);
        this.setDataLength(position + 32L + 9L + 2L + (long)length);
        return position;
    }

    private void setDataLength(long value) {
        if (value < this.dataLength) {
            throw new Error("PANIC! New data length is less than the old data length");
        }
        this.dataLength = value;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public synchronized Hash getRootHash() throws IOException {
        MappedByteBuffer mbb = this.seekMap(10L);
        byte[] bs = new byte[32];
        mbb.get(bs);
        return Hash.wrap(bs);
    }

    public synchronized void setRootHash(Hash h) throws IOException {
        MappedByteBuffer mbb = this.seekMap(10L);
        byte[] bs = h.getBytes();
        assert (bs.length == 32);
        mbb.put(bs);
    }

    public void setStore(EtchStore etchStore) {
        this.store = etchStore;
    }
}

