/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

public class Bits {
    public static int indexForDigit(int digit, short mask) {
        if ((mask & 1 << digit) == 0) {
            return -1;
        }
        return Bits.positionForDigit(digit, mask);
    }

    public static int positionForDigit(int digit, short mask) {
        return Integer.bitCount(mask & (1 << digit) - 1);
    }

    public static int leadingZeros(int x) {
        if (x == 0) {
            return 32;
        }
        int result = 0;
        if ((x & 0xFFFF0000) == 0) {
            result += 16;
        } else {
            x >>>= 16;
        }
        if ((x & 0xFF00) == 0) {
            result += 8;
        } else {
            x >>>= 8;
        }
        if ((x & 0xF0) == 0) {
            result += 4;
        } else {
            x >>>= 4;
        }
        if ((x & 0xC) == 0) {
            result += 2;
        } else {
            x >>>= 2;
        }
        if ((x & 2) == 0) {
            ++result;
        } else {
            x >>>= 1;
        }
        return result;
    }

    public static int leadingZeros(long x) {
        int highWord = (int)(x >>> 32);
        if (highWord != 0) {
            return Bits.leadingZeros(highWord);
        }
        int lowWord = (int)x;
        return 32 + Bits.leadingZeros(lowWord);
    }

    public static int lowBitMask(int numBits) {
        return (1 << numBits) - 1;
    }

    public static int lowBits(int numBits, int val) {
        return val & Bits.lowBitMask(numBits);
    }

    public static int leadingOnes(long value) {
        return Long.numberOfLeadingZeros(value ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

