/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import java.nio.ByteBuffer;

public class Transfer
extends ATransaction {
    public static final long TRANSFER_JUICE = 200L;
    protected final Address target;
    protected final long amount;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.TARGET, Keywords.AMOUNT};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    protected Transfer(Address origin, long sequence, Address target, long amount) {
        super(FORMAT.count(), origin, sequence);
        this.target = target;
        this.amount = amount;
    }

    public static Transfer create(Address origin, long sequence, Address target, long amount) {
        return new Transfer(origin, sequence, target, amount);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -47;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = this.target.encodeRaw(bs, pos);
        pos = Format.writeVLCLong(bs, pos, this.amount);
        return pos;
    }

    public static Transfer read(ByteBuffer bb) throws BadFormatException {
        Address origin = Address.create(Format.readVLCLong(bb));
        long sequence = Format.readVLCLong(bb);
        Address target = Address.readRaw(bb);
        long amount = Format.readVLCLong(bb);
        if (!RT.isValidAmount(amount)) {
            throw new BadFormatException("Invalid amount: " + amount);
        }
        return Transfer.create(origin, sequence, target, amount);
    }

    public static ATransaction read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        long aval = Format.readVLCLong(b, epos);
        Address origin = Address.create(aval);
        long sequence = Format.readVLCLong(b, epos += Format.getVLCLength(aval));
        long tval = Format.readVLCLong(b, epos += Format.getVLCLength(sequence));
        Address target = Address.create(tval);
        long amount = Format.readVLCLong(b, epos += Format.getVLCLength(tval));
        Transfer result = Transfer.create(origin, sequence, target, amount);
        result.attachEncoding(b.slice(pos, epos += Format.getVLCLength(amount)));
        return result;
    }

    @Override
    public Context apply(Context ctx) {
        if (!(ctx = ctx.consumeJuice(200L)).isExceptional()) {
            ctx = ctx.transfer(this.target, this.amount);
        }
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 56;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.amount < 0L || this.amount > 1000000000000000000L) {
            throw new InvalidDataException("Invalid amount", this);
        }
        if (this.target == null) {
            throw new InvalidDataException("Null Address", this);
        }
    }

    public Address getTarget() {
        return this.target;
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public Transfer withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Transfer.create(this.origin, newSequence, this.target, this.amount);
    }

    @Override
    public Transfer withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Transfer.create(newAddress, this.sequence, this.target, this.amount);
    }

    @Override
    public byte getTag() {
        return -47;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.AMOUNT.equals(key)) {
            return CVMLong.create(this.amount);
        }
        if (Keywords.ORIGIN.equals(key)) {
            return this.origin;
        }
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.TARGET.equals(key)) {
            return this.target;
        }
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

