/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.ops.AMultiOp;

public class Query<T extends ACell>
extends AMultiOp<T> {
    protected Query(AVector<AOp<ACell>> ops) {
        super(ops);
    }

    public static <T extends ACell> Query<T> create(AOp<?> ... ops) {
        return new Query<T>(Vectors.create(ops));
    }

    @Override
    protected Query<T> recreate(ASequence<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return new Query<T>(newOps.toVector());
    }

    public static <T extends ACell> Query<T> create(ASequence<AOp<ACell>> ops) {
        return new Query<T>(ops.toVector());
    }

    @Override
    public Context execute(Context context) {
        AOp op;
        State savedState = context.getState();
        int n = this.ops.size();
        if (n == 0) {
            return context.withResult(10L, null);
        }
        Context ctx = context.consumeJuice(10L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        AVector<ACell> savedBindings = context.getLocalBindings();
        for (int i = 0; i < n && !(ctx = ctx.execute(op = (AOp)this.ops.get(i))).isExceptional(); ++i) {
        }
        ctx = ctx.withState(savedState);
        ctx = ctx.withLocalBindings(savedBindings);
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(query");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (((AOp)this.ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public byte opCode() {
        return 9;
    }

    public static <T extends ACell> Query<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        AVector ops = (AVector)Format.read(b, epos);
        Query<T> result = Query.create(ops);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(ops)));
        return result;
    }
}

