/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AFn;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.ops.AMultiOp;
import convex.core.lang.ops.Lookup;

public class Invoke<T extends ACell>
extends AMultiOp<T> {
    protected Invoke(AVector<AOp<ACell>> ops) {
        super(ops);
    }

    public static <T extends ACell> Invoke<T> create(ASequence<AOp<ACell>> ops) {
        AVector<AOp<ACell>> vops = ops.toVector();
        return new Invoke<T>(vops);
    }

    public static <T extends ACell> Invoke<T> create(AOp<?> ... ops) {
        return Invoke.create(Vectors.create(ops));
    }

    public static <T extends ACell, A extends AOp<ACell>, F extends AOp<ACell>> Invoke<T> create(F f, ASequence<A> args) {
        ASequence<A> nargs = args;
        AList<AOp<ACell>> ops = nargs.cons(f);
        return Invoke.create(ops);
    }

    @Override
    protected Invoke<T> recreate(ASequence<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return Invoke.create(newOps);
    }

    public static <T extends ACell> Invoke<T> create(String string, AOp<?> ... args) {
        return Invoke.create(Lookup.create(string), Vectors.create(args));
    }

    @Override
    public Context execute(Context context) {
        AOp fnOp = (AOp)this.ops.get(0);
        Context ctx = context.execute(fnOp);
        if (ctx.isExceptional()) {
            return ctx;
        }
        Object rf = ctx.getResult();
        AFn fn = RT.castFunction(rf);
        if (fn == null) {
            return context.withCastError(0, (AType)Types.FUNCTION);
        }
        int arity = this.ops.size() - 1;
        ACell[] args = new ACell[arity];
        for (int i = 0; i < arity; ++i) {
            AOp argOp = (AOp)this.ops.get(i + 1);
            if ((ctx = ctx.execute(argOp)).isExceptional()) {
                return ctx;
            }
            args[i] = ctx.getResult();
        }
        if ((ctx = ctx.invoke(fn, args)).isError()) {
            ctx.getError().addTrace("In expression: " + RT.print(this));
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append('(');
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                bb.append(' ');
            }
            if (((AOp)this.ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public byte opCode() {
        return 2;
    }

    public static <T extends ACell> Invoke<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        AVector ops = (AVector)Format.read(b, epos);
        Invoke<T> result = Invoke.create(ops);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(ops)));
        return result;
    }
}

