/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.Symbols;
import convex.core.lang.impl.AClosure;

public class Fn<T extends ACell>
extends AClosure<T> {
    private final AVector<ACell> params;
    private final AOp<T> body;
    private Long variadic = null;

    private Fn(AVector<ACell> params, AOp<T> body, AVector<ACell> lexicalEnv) {
        super(lexicalEnv);
        this.params = params;
        this.body = body;
    }

    public static <T extends ACell, I> Fn<T> create(AVector<ACell> params, AOp<T> body) {
        AVector<ACell> binds = Context.EMPTY_BINDINGS;
        return new Fn<T>(params, body, binds);
    }

    @Override
    public <F extends AClosure<T>> F withEnvironment(AVector<ACell> env) {
        if (this.lexicalEnv == env) {
            return (F)this;
        }
        return (F)new Fn<T>(this.params, this.body, env);
    }

    @Override
    public boolean hasArity(int n) {
        long var = this.checkVariadic();
        long pc = this.params.count();
        if (var >= 0L) {
            return (long)n >= pc - 2L;
        }
        return (long)n == pc;
    }

    private Long checkVariadic() {
        if (this.variadic != null) {
            return this.variadic;
        }
        long pc = this.params.count();
        int i = 0;
        while ((long)i < pc - 1L) {
            Object param = this.params.get(i);
            if (Symbols.AMPERSAND.equals((ACell)param)) {
                this.variadic = i + 1;
                return this.variadic;
            }
            ++i;
        }
        this.variadic = -1L;
        return -1L;
    }

    @Override
    public Context invoke(Context context, ACell[] args) {
        AVector<ACell> savedBindings = context.getLocalBindings();
        Context boundContext = (context = context.withLocalBindings(this.lexicalEnv)).updateBindings(this.params, args);
        if (boundContext.isExceptional()) {
            return boundContext.withLocalBindings(savedBindings);
        }
        Context ctx = boundContext.execute(this.body);
        return ctx.withLocalBindings(savedBindings);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.params.encode(bs, pos);
        pos = this.body.encode(bs, pos);
        pos = this.lexicalEnv.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.params.estimatedEncodingSize() + this.body.estimatedEncodingSize() + this.lexicalEnv.estimatedEncodingSize();
    }

    public static <T extends ACell> Fn<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        AVector params = (AVector)Format.read(b, epos);
        if (params == null) {
            throw new BadFormatException("Null parameters to Fn");
        }
        AOp body = (AOp)Format.read(b, epos += Format.getEncodingLength(params));
        if (body == null) {
            throw new BadFormatException("Null body in Fn");
        }
        AVector lexicalEnv = (AVector)Format.read(b, epos += Format.getEncodingLength(body));
        Fn<T> result = new Fn<T>(params, body, lexicalEnv);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(lexicalEnv)));
        return result;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(fn ");
        this.printInternal(sb, limit);
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    public boolean printInternal(BlobBuilder sb, long limit) {
        sb.append('[');
        long size = this.params.count();
        for (long i = 0L; i < size; ++i) {
            if (i > 0L) {
                sb.append(' ');
            }
            if (RT.print(sb, this.params.get(i), limit)) continue;
            return false;
        }
        sb.append(']');
        sb.append(' ');
        return this.body.print(sb, limit);
    }

    public AVector<ACell> getParams() {
        return this.params;
    }

    public AOp<T> getBody() {
        return this.body;
    }

    @Override
    public int getRefCount() {
        return this.params.getRefCount() + this.body.getRefCount() + this.lexicalEnv.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int pc = this.params.getRefCount();
        if (i < pc) {
            return this.params.getRef(i);
        }
        int bc = this.body.getRefCount();
        if ((i -= pc) < bc) {
            return this.body.getRef(i);
        }
        return this.lexicalEnv.getRef(i -= bc);
    }

    @Override
    public Fn<T> updateRefs(IRefFunction func) {
        ACell newParams = this.params.updateRefs(func);
        ACell newBody = this.body.updateRefs(func);
        ACell newLexicalEnv = this.lexicalEnv.updateRefs(func);
        if (this.params == newParams && this.body == newBody && this.lexicalEnv == newLexicalEnv) {
            return this;
        }
        return new Fn<T>((AVector<ACell>)newParams, newBody, this.lexicalEnv);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.params.validateCell();
        this.body.validateCell();
        this.lexicalEnv.validateCell();
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

