/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.LongBlob;
import convex.core.data.Strings;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMDouble;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.math.BigInteger;

public final class CVMLong
extends AInteger {
    private static final int CACHE_SIZE = 256;
    private static final CVMLong[] CACHE = new CVMLong[256];
    public static final CVMLong ZERO;
    public static final CVMLong ONE;
    public static final CVMLong MINUS_ONE;
    public static final CVMLong MAX_VALUE;
    public static final CVMLong MIN_VALUE;
    public static final int MAX_ENCODING_LENGTH = 9;
    private final long value;

    public CVMLong(long value) {
        this.value = value;
    }

    public static CVMLong create(long value) {
        if (value < 256L && value >= 0L) {
            return CVMLong.forByte((byte)value);
        }
        return new CVMLong(value);
    }

    public static CVMLong create(Long value) {
        return CVMLong.create((long)value);
    }

    public static CVMLong forByte(byte b) {
        return CACHE[0xFF & b];
    }

    @Override
    public AType getType() {
        return Types.INTEGER;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public CVMLong toLong() {
        return this;
    }

    @Override
    public CVMDouble toDouble() {
        return CVMDouble.create(this.doubleValue());
    }

    @Override
    public int estimatedEncodingSize() {
        return 11;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        int numBytes = Format.getLongLength(this.value);
        bs[pos++] = (byte)(16 + numBytes);
        return this.encodeRaw(bs, pos, numBytes);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int numBytes = Format.getLongLength(this.value);
        return this.encodeRaw(bs, pos, numBytes);
    }

    private int encodeRaw(byte[] bs, int pos, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            bs[pos + i] = (byte)(this.value >> (numBytes - 1 - i << 3));
        }
        return pos + numBytes;
    }

    public static CVMLong read(byte tag, Blob blob, int offset) throws BadFormatException {
        int numBytes = tag - 16;
        if (numBytes == 0) {
            return ZERO;
        }
        long v = Format.readLong(blob, offset + 1, numBytes);
        long end = offset + 1 + numBytes;
        CVMLong result = CVMLong.create(v);
        if (result.encoding == null) {
            result.attachEncoding(blob.slice(offset, end));
        }
        return result;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toCVMString(20L));
        return bb.check(limit);
    }

    @Override
    public Class<?> numericType() {
        return Long.class;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMLong parse(Object o) {
        Number n;
        Long lv;
        if (o instanceof ACell) {
            CVMLong v = RT.ensureLong((ACell)o);
            if (v != null) {
                return v;
            }
            if (o instanceof AString) {
                return CVMLong.parse(o.toString());
            }
        }
        if (o instanceof Long) {
            return CVMLong.create((long)((Long)o));
        }
        if (o instanceof Number && (lv = Long.valueOf((n = (Number)o).longValue())).doubleValue() == n.doubleValue()) {
            return CVMLong.create((long)lv);
        }
        if (o instanceof String) {
            return CVMLong.parse((String)o);
        }
        return null;
    }

    public static CVMLong parse(String s) {
        try {
            return CVMLong.create(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public byte getTag() {
        if (this.encoding != null) {
            return this.encoding.byteAt(0L);
        }
        return (byte)(16 + Format.getLongLength(this.value));
    }

    @Override
    public CVMLong signum() {
        if (this.value > 0L) {
            return ONE;
        }
        if (this.value < 0L) {
            return MINUS_ONE;
        }
        return ZERO;
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 1L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public boolean equals(ACell c) {
        if (c == this) {
            return true;
        }
        if (c instanceof CVMLong) {
            return this.equals((CVMLong)c);
        }
        if (c instanceof CVMBigInteger) {
            CVMBigInteger bi = (CVMBigInteger)c;
            if (c.isCanonical()) {
                return false;
            }
            return this.value == bi.longValue();
        }
        return false;
    }

    public boolean equals(CVMLong c) {
        return c.value == this.value;
    }

    public static final CVMLong forSignum(long value) {
        if (value > 0L) {
            return ONE;
        }
        if (value < 0L) {
            return MINUS_ONE;
        }
        return ZERO;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public AInteger abs() {
        if (this.value >= 0L) {
            return this;
        }
        if (this.value == Long.MIN_VALUE) {
            return CVMBigInteger.MIN_POSITIVE;
        }
        return CVMLong.create(-this.value);
    }

    @Override
    public AInteger inc() {
        if (this.value == Long.MAX_VALUE) {
            return CVMBigInteger.MIN_POSITIVE;
        }
        return CVMLong.create(this.value + 1L);
    }

    @Override
    public AInteger dec() {
        if (this.value == Long.MIN_VALUE) {
            return CVMBigInteger.MIN_NEGATIVE;
        }
        return CVMLong.create(this.value - 1L);
    }

    @Override
    public int compareTo(ANumeric o) {
        if (o instanceof CVMLong) {
            return Long.compare(this.value, o.longValue());
        }
        if (o instanceof CVMBigInteger) {
            return -((CVMBigInteger)o).compareTo(this);
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    @Override
    public CVMLong ensureLong() {
        return this;
    }

    @Override
    public long byteLength() {
        return Utils.byteLength(this.value);
    }

    @Override
    public AInteger add(AInteger a) {
        if (a instanceof CVMLong) {
            return this.add((CVMLong)a);
        }
        return a.add(this);
    }

    public AInteger add(CVMLong b) {
        long av = this.value;
        long bv = b.value;
        if (bv == 0L) {
            return this;
        }
        if (av == 0L) {
            return b;
        }
        long r = av + bv;
        if (av > 0L ^ bv > 0L) {
            return CVMLong.create(r);
        }
        if (av > 0L && bv > 0L && r > 0L) {
            return CVMLong.create(r);
        }
        if (av < 0L && bv < 0L && r < 0L) {
            return CVMLong.create(r);
        }
        BigInteger bi = BigInteger.valueOf(av);
        bi = bi.add(BigInteger.valueOf(bv));
        return CVMBigInteger.wrap(bi).toCanonical();
    }

    @Override
    public AInteger sub(AInteger a) {
        if (a instanceof CVMLong) {
            return this.sub((CVMLong)a);
        }
        BigInteger bi = this.big();
        bi = bi.subtract(a.big());
        return CVMBigInteger.wrap(bi).toCanonical();
    }

    public AInteger sub(CVMLong b) {
        long av = this.value;
        long bv = b.value;
        if (bv == 0L) {
            return this;
        }
        BigInteger bi = BigInteger.valueOf(av);
        bi = bi.subtract(BigInteger.valueOf(bv));
        return CVMBigInteger.wrap(bi).toCanonical();
    }

    @Override
    public BigInteger big() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public AInteger negate() {
        if (this.value == Long.MIN_VALUE) {
            return CVMBigInteger.MIN_POSITIVE;
        }
        if (this.value == 0L) {
            return ZERO;
        }
        return CVMLong.create(-this.value);
    }

    @Override
    public ANumeric multiply(ANumeric b) {
        if (b instanceof CVMLong) {
            long av = this.value;
            long bv = ((CVMLong)b).value;
            long lo = av * bv;
            long hi = Math.multiplyHigh(av, bv);
            if (hi == 0L && lo >= 0L) {
                return CVMLong.create(lo);
            }
            if (hi == -1L && lo < 0L) {
                return CVMLong.create(lo);
            }
            BigInteger result = BigInteger.valueOf(av).multiply(BigInteger.valueOf(bv));
            return CVMBigInteger.wrap(result);
        }
        return b.multiply(this);
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public AInteger mod(AInteger base) {
        if (base instanceof CVMLong) {
            return this.mod((CVMLong)base);
        }
        return AInteger.create(this.big().mod(base.big()));
    }

    public CVMLong mod(CVMLong base) {
        long num = this.value;
        long denom = base.value;
        if (denom == 0L) {
            return null;
        }
        long m = num % denom;
        if (m < 0L) {
            m += Math.abs(denom);
        }
        return CVMLong.create(m);
    }

    @Override
    public AInteger div(AInteger base) {
        if (base instanceof CVMLong) {
            return this.div((CVMLong)base);
        }
        return null;
    }

    public CVMLong div(CVMLong base) {
        long num = this.value;
        long denom = base.value;
        if (denom == 0L) {
            return null;
        }
        if (num < 0L) {
            num -= denom - 1L;
        }
        long d = num / denom;
        return CVMLong.create(d);
    }

    @Override
    public AInteger rem(AInteger base) {
        if (base instanceof CVMLong) {
            return this.rem((CVMLong)base);
        }
        return null;
    }

    public CVMLong rem(CVMLong base) {
        long num = this.value;
        long denom = base.value;
        if (denom == 0L) {
            return null;
        }
        long r = num % denom;
        return CVMLong.create(r);
    }

    @Override
    public AInteger quot(AInteger base) {
        if (base instanceof CVMLong) {
            return this.quot((CVMLong)base);
        }
        return null;
    }

    public CVMLong quot(CVMLong base) {
        long num = this.value;
        long denom = base.value;
        if (denom == 0L) {
            return null;
        }
        long d = num / denom;
        return CVMLong.create(d);
    }

    @Override
    public AInteger toCanonical() {
        return this;
    }

    @Override
    public LongBlob toBlob() {
        return LongBlob.create(this.value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CVMLong.CACHE[i] = new CVMLong(i);
        }
        ZERO = CACHE[0];
        ONE = CACHE[1];
        MINUS_ONE = CVMLong.create(-1L);
        MAX_VALUE = CVMLong.create(Long.MAX_VALUE);
        MIN_VALUE = CVMLong.create(Long.MIN_VALUE);
    }
}

