/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Strings;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Text;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class StringShort
extends AString {
    public static final int MAX_EMBEDDED_STRING_LENGTH = 137;
    public static final int MAX_LENGTH = 4096;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCLength(4096L) + 4096;
    private final Blob data;
    public static final StringShort EMPTY = new StringShort(Blob.EMPTY);

    protected StringShort(Blob data) {
        super(data.length);
        this.data = data;
    }

    protected StringShort(byte[] data) {
        super(data.length);
        this.data = Blob.wrap(data);
    }

    protected StringShort(byte[] data, int offset, int length) {
        super(length);
        this.data = Blob.wrap(data, offset, length);
    }

    public static StringShort create(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        byte[] bs = string.getBytes(StandardCharsets.UTF_8);
        return new StringShort(bs);
    }

    public static StringShort create(AArrayBlob b) {
        if (b.count() == 0L) {
            return EMPTY;
        }
        return new StringShort(b.toFlatBlob());
    }

    @Override
    public byte byteAt(long index) {
        if (index < 0L || index >= this.length) {
            return -1;
        }
        return this.data.byteAt(index);
    }

    @Override
    public int intAt(long index) {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            long ix = index + (long)i;
            if (ix < 0L || ix >= this.length) {
                r |= 255 << 8 * (3 - i);
                continue;
            }
            r |= (0xFF & this.data.byteAt(ix)) << 8 * (3 - i);
        }
        return r;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length > 4096L) {
            throw new InvalidDataException("StringShort too long: " + this.length, this);
        }
        if (this.length != (long)this.data.length) {
            throw new InvalidDataException("Wrong String length!", this);
        }
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public int writeRawData(byte[] bs, int pos) {
        return this.data.getBytes(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 3 + (int)this.length;
    }

    @Override
    public boolean isCanonical() {
        return this.length <= 4096L;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return this.length <= 137L;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    public static AString read(long length, ByteBuffer bb) {
        byte[] data = new byte[Utils.checkedInt(length)];
        bb.get(data);
        return new StringShort(data);
    }

    public static StringShort read(long length, Blob blob, int pos) {
        int len = Utils.checkedInt(length);
        int dataOffset = pos + 1 + Format.getVLCLength(length);
        byte[] data = new byte[len];
        System.arraycopy(blob.getInternalArray(), blob.getInternalOffset() + dataOffset, data, 0, len);
        StringShort result = new StringShort(data);
        result.attachEncoding(blob.slice(pos, dataOffset + len));
        return result;
    }

    @Override
    public Blob toBlob() {
        return this.data;
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof StringShort) {
            return this.equals((StringShort)a);
        }
        return false;
    }

    public final boolean equals(StringShort a) {
        if (a == this) {
            return true;
        }
        return this.data.equals(a.data);
    }

    @Override
    public int compareTo(AString o) {
        return this.data.compareTo(o.toBlob());
    }

    @Override
    public ACell toCanonical() {
        if (this.length <= 4096L) {
            return this;
        }
        return Strings.create(this.data.toCanonical());
    }

    @Override
    public AString slice(long start, long end) {
        Blob newData = this.data.slice(start, end);
        if (this.data == newData) {
            return this;
        }
        if (newData == null) {
            return null;
        }
        return StringShort.create(newData);
    }

    @Override
    protected void printEscaped(BlobBuilder sb, long start, long end) {
        long n = this.count();
        if (start < 0L || start > end || end > n) {
            throw new IllegalArgumentException(Errors.badRange(start, end));
        }
        for (long i = start; i < end; ++i) {
            byte b = this.data.byteAtUnchecked(i);
            Text.writeEscapedByte(sb, b);
        }
    }
}

