/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMapEntry;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.MapTree;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.TODOException;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapLeaf<K extends ACell, V extends ACell>
extends AHashMap<K, V> {
    public static final int MAX_ENTRIES = 8;
    static final MapEntry<?, ?>[] EMPTY_ENTRIES = new MapEntry[0];
    private static final MapLeaf<?, ?> EMPTY = new MapLeaf(EMPTY_ENTRIES);
    private final MapEntry<K, V>[] entries;
    public static int MAX_ENCODING_LENGTH = 2242;

    private MapLeaf(MapEntry<K, V>[] items) {
        super(items.length);
        this.entries = items;
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> create(MapEntry<K, V>[] entries) {
        return MapLeaf.create(entries, 0, entries.length);
    }

    protected static <K extends ACell, V extends ACell> MapLeaf<K, V> create(MapEntry<K, V>[] entries, int offset, int length) {
        if (length == 0) {
            return MapLeaf.emptyMap();
        }
        if (length > 8) {
            throw new IllegalArgumentException("Too many entries: " + entries.length);
        }
        Object[] sorted = Utils.copyOfRangeExcludeNulls(entries, offset, offset + length);
        if (sorted.length == 0) {
            return MapLeaf.emptyMap();
        }
        Arrays.sort(sorted);
        return new MapLeaf<K, V>((MapEntry<K, V>[])sorted);
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> create(MapEntry<K, V> item) {
        return new MapLeaf<K, V>(new MapEntry[]{item});
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> unsafeCreate(MapEntry<K, V> ... items) {
        return new MapLeaf<K, V>(items);
    }

    @Override
    public MapEntry<K, V> getEntry(ACell k) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> e = this.entries[i];
            if (!Utils.equals(k, (ACell)e.getKey())) continue;
            return e;
        }
        return null;
    }

    @Override
    public MapEntry<K, V> getKeyRefEntry(Ref<ACell> ref) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> e = this.entries[i];
            if (!ref.equals(e.getKeyRef())) continue;
            return e;
        }
        return null;
    }

    @Override
    protected MapEntry<K, V> getEntryByHash(Hash hash) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> e = this.entries[i];
            if (!hash.equals(e.getKeyHash())) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean containsValue(ACell value) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Utils.equals(value, (ACell)this.entries[i].getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(ACell key) {
        MapEntry<K, V> me = this.getEntry(key);
        return (V)(me == null ? null : me.getValue());
    }

    private int seek(K key) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Utils.equals(key, (ACell)this.entries[i].getKey())) continue;
            return i;
        }
        return -1;
    }

    private int seekKeyRef(Ref<K> key) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Utils.equals(key, this.entries[i].getKeyRef())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public MapLeaf<K, V> dissoc(ACell key) {
        int i = this.seek(key);
        if (i < 0) {
            return this;
        }
        return this.dissocEntry(i);
    }

    @Override
    public MapLeaf<K, V> dissocRef(Ref<K> key) {
        int i = this.seekKeyRef(key);
        if (i < 0) {
            return this;
        }
        return this.dissocEntry(i);
    }

    private MapLeaf<K, V> dissocEntry(int internalIndex) {
        int len = this.size();
        if (len == 1) {
            return MapLeaf.emptyMap();
        }
        MapEntry[] newEntries = new MapEntry[len - 1];
        System.arraycopy(this.entries, 0, newEntries, 0, internalIndex);
        System.arraycopy(this.entries, internalIndex + 1, newEntries, internalIndex, len - internalIndex - 1);
        return new MapLeaf<K, V>(newEntries);
    }

    @Override
    public AHashMap<K, V> assocEntry(MapEntry<K, V> e) {
        return this.assocEntry(e, 0);
    }

    @Override
    public AHashMap<K, V> assocEntry(MapEntry<K, V> e, int shift) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> me = this.entries[i];
            if (e.equals(me)) {
                return this;
            }
            if (!me.getKeyRef().equals(e.getKeyRef())) continue;
            MapEntry[] newEntries = (MapEntry[])this.entries.clone();
            newEntries[i] = e;
            return new MapLeaf<K, V>(newEntries);
        }
        int newLen = len + 1;
        Object[] newEntries = new MapEntry[newLen];
        System.arraycopy(this.entries, 0, newEntries, 0, len);
        newEntries[newLen - 1] = e;
        if (newLen <= 8) {
            Arrays.sort(newEntries);
            return new MapLeaf<K, V>((MapEntry<K, V>[])newEntries);
        }
        return MapTree.create(newEntries, shift);
    }

    @Override
    public AHashMap<K, V> assoc(ACell key, ACell value) {
        return this.assoc(key, value, 0);
    }

    protected AHashMap<K, V> assoc(K key, V value, int shift) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> me = this.entries[i];
            if (!Utils.equals((ACell)me.getKey(), key)) continue;
            if (Utils.equals((ACell)me.getValue(), value)) {
                return this;
            }
            AMapEntry newEntry = me.withValue((ACell)value);
            if (me == newEntry) {
                return this;
            }
            MapEntry[] newEntries = (MapEntry[])this.entries.clone();
            newEntries[i] = newEntry;
            return new MapLeaf<K, V>(newEntries);
        }
        Object[] newEntries = new MapEntry[len + 1];
        System.arraycopy(this.entries, 0, newEntries, 0, len);
        newEntries[len] = MapEntry.create(key, value);
        if (len + 1 <= 8) {
            Arrays.sort(newEntries);
            return new MapLeaf<K, V>((MapEntry<K, V>[])newEntries);
        }
        return MapTree.create(newEntries, shift);
    }

    @Override
    protected AHashMap<K, V> assocRef(Ref<K> keyRef, V value, int shift) {
        return this.assoc(keyRef.getValue(), value, shift);
    }

    @Override
    public AHashMap<K, V> assocRef(Ref<K> keyRef, V value) {
        return this.assocRef(keyRef, value, 0);
    }

    @Override
    public Set<K> keySet() {
        int len = this.size();
        HashSet<Object> h = new HashSet<Object>(len);
        for (int i = 0; i < len; ++i) {
            MapEntry<K, V> me = this.entries[i];
            h.add(me.getKey());
        }
        return h;
    }

    @Override
    protected void accumulateKeySet(HashSet<K> h) {
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> me = this.entries[i];
            h.add(me.getKey());
        }
    }

    @Override
    protected void accumulateValues(ArrayList<V> al) {
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> me = this.entries[i];
            al.add(me.getValue());
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        int len = this.size();
        HashSet<Map.Entry<K, V>> h = new HashSet<Map.Entry<K, V>>(len);
        this.accumulateEntrySet(h);
        return h;
    }

    @Override
    protected void accumulateEntrySet(HashSet<Map.Entry<K, V>> h) {
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> me = this.entries[i];
            h.add(me);
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -126;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.count);
        int i = 0;
        while ((long)i < this.count) {
            pos = this.entries[i].encodeRaw(bs, pos);
            ++i;
        }
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 2 + 280 * this.size();
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> read(Blob b, int pos, long count) throws BadFormatException {
        int epos = pos + 2;
        MapEntry[] items = new MapEntry[(int)count];
        int i = 0;
        while ((long)i < count) {
            Ref kr = Format.readRef(b, epos);
            epos = (int)((long)epos + kr.getEncodingLength());
            Ref vr = Format.readRef(b, epos);
            epos = (int)((long)epos + vr.getEncodingLength());
            items[i] = MapEntry.createRef(kr, vr);
            ++i;
        }
        if (!MapLeaf.isValidOrder(items)) {
            throw new BadFormatException("Bad ordering of keys!");
        }
        MapLeaf<K, V> result = new MapLeaf<K, V>(items);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> emptyMap() {
        return EMPTY;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (MapEntry<K, V> e : this.entries) {
            action.accept(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    private static <K extends ACell, V extends ACell> boolean isValidOrder(MapEntry<K, V>[] entries) {
        long count = entries.length;
        int i = 0;
        while ((long)i < count - 1L) {
            Hash b;
            Hash a = entries[i].getKeyHash();
            if (a.compareTo(b = entries[i + 1].getKeyHash()) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getRefCount() {
        return 2 * this.entries.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        MapEntry<K, V> e = this.entries[i >> 1];
        if ((i & 1) == 0) {
            return e.getKeyRef();
        }
        return e.getValueRef();
    }

    @Override
    public MapLeaf updateRefs(IRefFunction func) {
        int n = this.entries.length;
        if (n == 0) {
            return this;
        }
        MapEntry<K, V>[] newEntries = this.entries;
        for (int i = 0; i < n; ++i) {
            MapEntry<K, V> e = newEntries[i];
            AVector newEntry = e.updateRefs(func);
            if (e == newEntry) continue;
            if (newEntries == this.entries) {
                newEntries = (MapEntry[])this.entries.clone();
            }
            newEntries[i] = newEntry;
        }
        if (newEntries == this.entries) {
            return this;
        }
        MapLeaf<K, V> result = new MapLeaf<K, V>(newEntries);
        result.attachEncoding(this.encoding);
        return result;
    }

    public MapLeaf<K, V> filterHexDigits(int digitPos, int mask) {
        if ((mask &= 0xFFFF) == 0) {
            return MapLeaf.emptyMap();
        }
        if (mask == 65535) {
            return this;
        }
        int sel = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Hash h = this.entries[i].getKeyHash();
            if ((mask & 1 << h.getHexDigit(digitPos)) == 0) continue;
            sel |= 1 << i;
        }
        if (sel == 0) {
            return MapLeaf.emptyMap();
        }
        return this.filterEntries(sel);
    }

    private MapLeaf<K, V> filterEntries(int selection) {
        if (selection == 0) {
            return MapLeaf.emptyMap();
        }
        int n = this.size();
        if (selection == (1 << n) - 1) {
            return this;
        }
        MapEntry[] newEntries = new MapEntry[Integer.bitCount(selection)];
        int ix = 0;
        for (int i = 0; i < n; ++i) {
            if ((selection & 1 << i) == 0) continue;
            newEntries[ix++] = this.entries[i];
        }
        assert (ix == Integer.bitCount(selection));
        return new MapLeaf<K, V>(newEntries);
    }

    @Override
    public MapEntry<K, V> entryAt(long i) {
        return this.entries[(int)i];
    }

    @Override
    public AHashMap<K, V> mergeWith(AHashMap<K, V> b, MergeFunction<V> func) {
        return this.mergeWith(b, func, 0);
    }

    @Override
    protected AHashMap<K, V> mergeWith(AHashMap<K, V> b, MergeFunction<V> func, int shift) {
        if (b instanceof MapLeaf) {
            return this.mergeWith((MapLeaf)b, func, shift);
        }
        if (b instanceof MapTree) {
            return ((MapTree)b).mergeWith(this, func.reverse());
        }
        throw new TODOException("Unhandled map type: " + b.getClass());
    }

    @Override
    private AHashMap<K, V> mergeWith(MapLeaf<K, V> b, MergeFunction<V> func, int shift) {
        int al = this.size();
        int bl = b.size();
        int ai = 0;
        int bi = 0;
        ArrayList<AMapEntry> results = null;
        while (ai < al || bi < bl) {
            ACell r;
            MapEntry<K, V> be;
            MapEntry<K, V> ae = ai < al ? this.entries[ai] : null;
            MapEntry<K, V> mapEntry = be = bi < bl ? b.entries[bi] : null;
            int c = ae == null ? 1 : (be == null ? -1 : ae.getKeyHash().compareTo(be.getKeyHash()));
            AMapEntry newE = null;
            if (c < 0) {
                r = func.merge(ae.getValue(), null);
                if (r != null) {
                    newE = ae.withValue(r);
                }
            } else if (c > 0) {
                r = (ACell)func.merge(null, be.getValue());
                if (r != null) {
                    newE = be.withValue(r);
                }
            } else {
                r = (ACell)func.merge(ae.getValue(), be.getValue());
                if (r != null) {
                    newE = ae.withValue(r);
                }
            }
            if (results == null && newE != (c <= 0 ? ae : null)) {
                results = new ArrayList<AMapEntry>(16);
                for (int i = 0; i < ai; ++i) {
                    results.add(this.entries[i]);
                }
            }
            if (c <= 0) {
                ++ai;
            }
            if (c >= 0) {
                ++bi;
            }
            if (results == null || newE == null) continue;
            results.add(newE);
        }
        if (results == null) {
            return this;
        }
        return Maps.createWithShift(shift, results);
    }

    @Override
    public AHashMap<K, V> mergeDifferences(AHashMap<K, V> b, MergeFunction<V> func) {
        return this.mergeDifferences(b, func, 0);
    }

    @Override
    protected AHashMap<K, V> mergeDifferences(AHashMap<K, V> b, MergeFunction<V> func, int shift) {
        if (b instanceof MapLeaf) {
            return this.mergeDifferences((MapLeaf)b, func, shift);
        }
        if (b instanceof MapTree) {
            return b.mergeWith(this, func.reverse());
        }
        throw new TODOException("Unhandled map type: " + b.getClass());
    }

    @Override
    public AHashMap<K, V> mergeDifferences(MapLeaf<K, V> b, MergeFunction<V> func, int shift) {
        if (this.equals(b)) {
            return this;
        }
        int al = this.size();
        int bl = b.size();
        int ai = 0;
        int bi = 0;
        ArrayList<AMapEntry> results = null;
        while (ai < al || bi < bl) {
            ACell r;
            MapEntry<K, V> be;
            MapEntry<K, V> ae = ai < al ? this.entries[ai] : null;
            MapEntry<K, V> mapEntry = be = bi < bl ? b.entries[bi] : null;
            int c = ae == null ? 1 : (be == null ? -1 : ae.getKeyHash().compareTo(be.getKeyHash()));
            AMapEntry newE = null;
            if (c < 0) {
                r = func.merge(ae.getValue(), null);
                if (r != null) {
                    newE = ae.withValue(r);
                }
            } else if (c > 0) {
                r = (ACell)func.merge(null, be.getValue());
                if (r != null) {
                    newE = be.withValue(r);
                }
            } else {
                Object bv;
                Object r2;
                Object av = ae.getValue();
                Object object = r2 = Utils.equals((ACell)av, (ACell)(bv = be.getValue())) ? av : (ACell)func.merge(ae.getValue(), be.getValue());
                if (r2 != null) {
                    newE = ae.withValue((ACell)r2);
                }
            }
            if (results == null && newE != (c <= 0 ? ae : null)) {
                results = new ArrayList<AMapEntry>(16);
                for (int i = 0; i < ai; ++i) {
                    results.add(this.entries[i]);
                }
            }
            if (c <= 0) {
                ++ai;
            }
            if (c >= 0) {
                ++bi;
            }
            if (results == null || newE == null) continue;
            results.add(newE);
        }
        if (results == null) {
            return this;
        }
        return Maps.createWithShift(shift, results);
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> func, R initial) {
        int n = this.size();
        R result = initial;
        for (int i = 0; i < n; ++i) {
            result = func.apply(result, this.entries[i].getValue());
        }
        return result;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> func, R initial) {
        int n = this.size();
        R result = initial;
        for (int i = 0; i < n; ++i) {
            result = func.apply(result, this.entries[i]);
        }
        return result;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof MapLeaf)) {
            return false;
        }
        return this.equals((MapLeaf)a);
    }

    public boolean equals(MapLeaf<K, V> a) {
        if (this == a) {
            return true;
        }
        int n = this.size();
        if (n != a.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.entries[i].equals(a.entries[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public MapLeaf<K, V> mapEntries(Function<MapEntry<K, V>, MapEntry<K, V>> func) {
        MapEntry<K, V>[] newEntries = this.entries;
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> e = this.entries[i];
            MapEntry<K, V> newE = func.apply(e);
            if (e == newE) continue;
            if (newE != null && !e.keyEquals(newE)) {
                throw new IllegalArgumentException("Function changed Key: " + (ACell)e.getKey());
            }
            if (newEntries == this.entries) {
                newEntries = (MapEntry[])this.entries.clone();
            }
            newEntries[i] = newE;
        }
        if (newEntries == this.entries) {
            return this;
        }
        return MapLeaf.create(newEntries);
    }

    @Override
    protected void validateWithPrefix(String prefix) throws InvalidDataException {
        this.validate();
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> e = this.entries[i];
            Hash h = e.getKeyRef().getHash();
            if (!h.toHexString().startsWith(prefix)) {
                throw new InvalidDataException("Prefix " + prefix + " invalid for map entry: " + e + " with hash: " + h, this);
            }
            e.validate();
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count == 0L && this != EMPTY) {
            throw new InvalidDataException("Empty map not using canonical instance", this);
        }
        if (this.count > 8L) {
            throw new InvalidDataException("Too many items in list map: " + this.entries.length, this);
        }
        if (!MapLeaf.isValidOrder(this.entries)) {
            throw new InvalidDataException("Invalid key ordering", this);
        }
    }

    @Override
    public boolean containsAllKeys(AHashMap<K, V> b) {
        if (this == b) {
            return true;
        }
        if (b.count() > this.count) {
            return false;
        }
        return this.containsAllKeys((MapLeaf)b);
    }

    @Override
    protected boolean containsAllKeys(MapLeaf<K, V> b) {
        int ix = 0;
        block0: for (MapEntry<K, V> meb : b.entries) {
            Hash bh = meb.getKeyHash();
            if ((long)ix >= this.count) {
                return false;
            }
            while ((long)ix < this.count) {
                MapEntry<K, V> mea = this.entries[ix];
                Hash ah = mea.getKeyHash();
                int c = ah.compareTo(bh);
                if (c < 0) {
                    if ((long)(++ix) < this.count) continue;
                    return false;
                }
                if (c > 0) {
                    return false;
                }
                ++ix;
                continue block0;
            }
        }
        return true;
    }

    @Override
    public byte getTag() {
        return -126;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public MapLeaf<K, V> slice(long start, long end) {
        if (start < 0L || end > this.count) {
            return null;
        }
        if (end < start) {
            return null;
        }
        int n = (int)(end - start);
        if (n == 0) {
            return (MapLeaf)Maps.empty();
        }
        if ((long)n == this.count) {
            return this;
        }
        MapEntry[] nrefs = new MapEntry[n];
        System.arraycopy(this.entries, (int)start, nrefs, 0, n);
        return new MapLeaf<K, V>(nrefs);
    }
}

