/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Belief;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.Order;
import convex.core.Result;
import convex.core.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.BlobMap;
import convex.core.data.Blobs;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Maps;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.Refs;
import convex.core.data.Sets;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.Core;
import convex.core.lang.Ops;
import convex.core.lang.RT;
import convex.core.lang.impl.Fn;
import convex.core.lang.impl.MultiFn;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Call;
import convex.core.transactions.Invoke;
import convex.core.transactions.Multi;
import convex.core.transactions.Transfer;
import convex.core.util.Bits;
import convex.core.util.Trees;
import convex.core.util.Utils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;

public class Format {
    public static final int LIMIT_ENCODING_LENGTH = 8191;
    public static final int MAX_VLC_LONG_LENGTH = 10;
    public static final int MAX_EMBEDDED_LENGTH = 140;
    public static final int NULL_ENCODING_LENGTH = 1;
    public static final int MAX_REF_LENGTH = Math.max(33, 140);
    public static final long MAX_MESSAGE_LENGTH = 10000000L;

    public static int getVLCLength(long x) {
        if (x < 64L && x >= -64L) {
            return 1;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        return blen;
    }

    public static ByteBuffer writeVLCLong(ByteBuffer bb, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            return bb.put(single);
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bb = bb.put(single);
        }
        byte end = (byte)(x & 0x7FL);
        return bb.put(end);
    }

    public static int writeVLCLong(byte[] bs, int pos, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            bs[pos++] = single;
            return pos;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bs[pos++] = single;
        }
        byte end = (byte)(x & 0x7FL);
        bs[pos++] = end;
        return pos;
    }

    public static long readVLCLong(ByteBuffer bb) throws BadFormatException {
        boolean signOnly;
        byte octet = bb.get();
        long result = Format.vlcSignExtend(octet);
        int bitsRead = 7;
        int sevenBits = octet & 0x7F;
        boolean bl = signOnly = sevenBits == 0 || sevenBits == 127;
        while ((octet & 0x80) != 0) {
            if (bitsRead > 64) {
                throw new BadFormatException("VLC long encoding too long for long value");
            }
            octet = bb.get();
            sevenBits = octet & 0x7F;
            if (signOnly && bitsRead == 7) {
                boolean resultSignBit;
                boolean signBit = (sevenBits & 0x40) != 0;
                boolean bl2 = resultSignBit = result < 0L;
                if (signBit == resultSignBit) {
                    throw new BadFormatException("VLC long encoding not canonical, excess leading sign byte(s)");
                }
            }
            result = result << 7 | (long)sevenBits;
            bitsRead += 7;
        }
        if (bitsRead > 63 && !signOnly) {
            throw new BadFormatException("VLC long encoding not canonical, non-sign information beyond 63 bits read");
        }
        return result;
    }

    public static long vlcSignExtend(byte b) {
        return (long)b << 57 >> 57;
    }

    public static long readVLCLong(AArrayBlob blob, int pos) throws BadFormatException {
        byte[] data = blob.getInternalArray();
        return Format.readVLCLong(data, pos + blob.getInternalOffset());
    }

    public static long readVLCLong(byte[] data, int pos) throws BadFormatException {
        byte octet = data[pos++];
        long result = (long)octet << 57 >> 57;
        int bits = 7;
        while ((octet & 0x80) != 0) {
            if (pos >= data.length) {
                throw new BadFormatException("VLC encoding beyond end of array");
            }
            if (bits > 64) {
                throw new BadFormatException("VLC encoding too long for long value");
            }
            octet = data[pos++];
            result = result << 7 | (long)(octet & 0x7F);
            bits += 7;
        }
        return result;
    }

    public static int peekMessageLength(ByteBuffer bb) throws BadFormatException {
        int remaining = bb.limit();
        if (remaining == 0) {
            return -1;
        }
        int len = bb.get(0);
        if (len == 0) {
            throw new BadFormatException("Format.peekMessageLength: Zero message length:" + Utils.readBufferData(bb));
        }
        if ((len & 0x40) != 0) {
            String hex = Utils.toHexString((byte)len);
            throw new BadFormatException("Format.peekMessageLength: Expected positive VLC message length, got first byte [" + hex + "]");
        }
        if ((len & 0x80) == 0) {
            return len & 0x3F;
        }
        len &= 0x7F;
        for (int i = 1; i < 10; ++i) {
            if (i >= remaining) {
                return -1;
            }
            byte lsb = bb.get(i);
            len = (len << 7) + (lsb & 0x7F);
            if ((lsb & 0x80) != 0) continue;
            return len;
        }
        throw new BadFormatException("Format.peekMessageLength: Too many bytes in length encoding");
    }

    public static ByteBuffer writeMessageLength(ByteBuffer bb, int len) {
        return Format.writeVLCLong(bb, len);
    }

    public static int write(byte[] bs, int pos, ACell cell) {
        if (cell == null) {
            bs[pos++] = 0;
            return pos;
        }
        Blob enc = cell.cachedEncoding();
        if (enc != null) {
            pos = enc.getBytes(bs, pos);
            return pos;
        }
        return cell.encode(bs, pos);
    }

    public static int writeRawUTF8String(byte[] bs, int pos, String s) {
        if (s.length() == 0) {
            return Format.writeVLCLong(bs, pos, 0L);
        }
        byte[] sBytes = Utils.toByteArray(s);
        int n = sBytes.length;
        pos = Format.writeVLCLong(bs, pos, sBytes.length);
        System.arraycopy(sBytes, 0, bs, pos, n);
        return pos + n;
    }

    public static AString readUTF8String(ByteBuffer bb, int len) throws BadFormatException {
        try {
            if (len == 0) {
                return Strings.empty();
            }
            byte[] bs = new byte[len];
            bb.get(bs);
            AString s = Strings.create(Blob.wrap(bs));
            return s;
        }
        catch (BufferUnderflowException e) {
            throw new BadFormatException("Buffer underflow", e);
        }
    }

    public static AString readUTF8String(Blob blob, int pos, int len) throws BadFormatException {
        if (len == 0) {
            return Strings.empty();
        }
        if (blob.count() < (long)(pos + len)) {
            throw new BadFormatException("Insufficient bytes in blob to read UTF-8 bytes");
        }
        byte[] bs = new byte[len];
        System.arraycopy(blob.getInternalArray(), blob.getInternalOffset() + pos, bs, 0, len);
        AString s = Strings.create(Blob.wrap(bs));
        return s;
    }

    public static ByteBuffer writeLength(ByteBuffer bb, int i) {
        bb = Format.writeVLCLong(bb, i);
        return bb;
    }

    public static <T extends ACell> Ref<T> readRef(Blob b, int pos) throws BadFormatException {
        byte tag = b.byteAt(pos);
        if (tag == 32) {
            return Ref.readRaw(b, pos + 1);
        }
        T cell = Format.read(tag, b, pos);
        if (!Format.isEmbedded(cell)) {
            throw new BadFormatException("Non-embedded Cell found instead of ref: type = " + RT.getType(cell));
        }
        return Ref.get(cell);
    }

    private static <T extends ACell> T readDataStructure(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -128) {
            return (T)Vectors.read(b, pos);
        }
        if (tag == -126) {
            return (T)Maps.read(b, pos);
        }
        if (tag == -120) {
            return (T)Syntax.read(b, pos);
        }
        if (tag == -125) {
            return (T)Sets.read(b, pos);
        }
        if (tag == -127) {
            return (T)List.read(b, pos);
        }
        if (tag == -124) {
            return (T)BlobMap.read(b, pos);
        }
        throw new BadFormatException("Can't read data structure with tag byte: " + tag);
    }

    private static ACell readCode(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -52) {
            return Ops.read(b, pos);
        }
        if (tag == -51) {
            Symbol sym = Symbol.read(b, pos);
            Object o = Core.ENVIRONMENT.get(sym);
            if (o == null) {
                throw new BadFormatException("Core definition not found [" + sym + "]");
            }
            return o;
        }
        if (tag == -53) {
            MultiFn fn = MultiFn.read(b, pos);
            return fn;
        }
        if (tag == -49) {
            Fn fn = Fn.read(b, pos);
            return fn;
        }
        throw new BadFormatException("Can't read Op with tag byte: " + Utils.toHexString(tag));
    }

    public static <T extends ACell> T read(Blob blob) throws BadFormatException {
        long n = blob.count();
        if (n < 1L) {
            throw new BadFormatException("Attempt to decode from empty Blob");
        }
        byte tag = blob.byteAt(0L);
        T result = Format.read(tag, blob, 0);
        if (result == null) {
            if (n != 1L) {
                throw new BadFormatException("Decode of null value but blob size = " + n);
            }
        } else if (((ACell)result).getEncoding().count() != n) {
            throw new BadFormatException("Excess bytes in read from Blob");
        }
        return result;
    }

    public static <T extends ACell> T read(Blob blob, int offset) throws BadFormatException {
        byte tag = blob.byteAt(offset);
        T result = Format.read(tag, blob, offset);
        return result;
    }

    public static <T extends ACell> T read(String hexString) throws BadFormatException {
        return Format.read(Blob.fromHex(hexString));
    }

    private static <T extends ACell> T read(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == 0) {
            return null;
        }
        if (tag == -79) {
            return (T)CVMBool.TRUE;
        }
        if (tag == -80) {
            return (T)CVMBool.FALSE;
        }
        try {
            int high = tag & 0xF0;
            if (high == 16) {
                return (T)Format.readNumeric(tag, blob, offset);
            }
            if (high == 48) {
                return (T)Format.readBasicObject(tag, blob, offset);
            }
            if (tag == 33) {
                return (T)Address.readRaw(blob, offset);
            }
            if (tag == -112) {
                return (T)SignedData.read(blob, offset);
            }
            if ((tag & 0xF0) == 128) {
                return Format.readDataStructure(tag, blob, offset);
            }
            if ((tag & 0xF0) == 160) {
                return Format.readRecord(tag, blob, offset);
            }
            if ((tag & 0xF0) == 208) {
                return (T)Format.readTransaction(tag, blob, offset);
            }
            if (tag == -62) {
                return (T)PeerStatus.read(blob, offset);
            }
            if (tag == -63) {
                return (T)AccountStatus.read(blob, offset);
            }
            if ((tag & 0xF0) == 192) {
                return (T)Format.readCode(tag, blob, offset);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadFormatException("Read out of blob bounds when decoding with tag " + tag);
        }
        catch (BadFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadFormatException("Unexpected Exception when decoding: " + e.getMessage(), e);
        }
        throw new BadFormatException("Don't recognise tag " + tag);
    }

    private static ANumeric readNumeric(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag < 25) {
            return CVMLong.read(tag, blob, offset);
        }
        if (tag == 25) {
            return CVMBigInteger.read(blob, offset);
        }
        if (tag == 29) {
            return CVMDouble.read(tag, blob, offset);
        }
        throw new BadFormatException("Can't read basic type with tag byte: " + tag);
    }

    private static ACell readBasicObject(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == 49) {
            return Blobs.read(blob, offset);
        }
        if (tag == 48) {
            return Strings.read(blob, offset);
        }
        if (tag == 50) {
            return Symbol.read(blob, offset);
        }
        if (tag == 51) {
            return Keyword.read(blob, offset);
        }
        if ((tag & 0x3C) == 60) {
            int len = CVMChar.utfByteCountFromTag(tag);
            if (len > 4) {
                throw new BadFormatException("Can't read char type with length: " + len);
            }
            return CVMChar.read(len, blob, offset);
        }
        throw new BadFormatException("Can't read basic type with tag byte: " + tag);
    }

    private static <T extends ACell> T readRecord(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -85) {
            return (T)Block.read(b, pos);
        }
        if (tag == -96) {
            return (T)State.read(b, pos);
        }
        if (tag == -84) {
            return (T)Order.read(b, pos);
        }
        if (tag == -86) {
            return (T)Belief.read(b, pos);
        }
        if (tag == -83) {
            return (T)Result.read(b, pos);
        }
        if (tag == -82) {
            return (T)BlockResult.read(b, pos);
        }
        throw new BadFormatException("Can't read record type with tag byte: " + tag);
    }

    private static ATransaction readTransaction(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -48) {
            return Invoke.read(b, pos);
        }
        if (tag == -47) {
            return Transfer.read(b, pos);
        }
        if (tag == -46) {
            return Call.read(b, pos);
        }
        if (tag == -45) {
            return Multi.read(b, pos);
        }
        throw new BadFormatException("Can't read Transaction with tag " + Utils.toHexString(tag));
    }

    public static boolean isCanonical(ACell o) {
        if (o == null) {
            return true;
        }
        return o.isCanonical();
    }

    public static boolean isEmbedded(ACell cell) {
        if (cell == null) {
            return true;
        }
        return cell.isEmbedded();
    }

    public static Blob encodedBlob(ACell o) {
        if (o == null) {
            return Blob.NULL_ENCODING;
        }
        return o.getEncoding();
    }

    public static ByteBuffer encodedBuffer(ACell cell) {
        return Format.encodedBlob(cell).getByteBuffer();
    }

    public static int writeHexDigits(byte[] bs, int pos, ABlob src, long start, long length) {
        pos = Format.writeVLCLong(bs, pos, start);
        pos = Format.writeVLCLong(bs, pos, length);
        int nBytes = Utils.checkedInt(length + 1L >> 1);
        byte[] bs2 = new byte[nBytes];
        for (int i = 0; i < nBytes; ++i) {
            long ix = start + (long)(i * 2);
            int d0 = src.getHexDigit(ix);
            int d1 = (long)(i * 2 + 1) < length ? src.getHexDigit(ix + 1L) : 0;
            bs2[i] = (byte)(d0 << 4 | d1 & 0xF);
        }
        System.arraycopy(bs2, 0, bs, pos, nBytes);
        return pos + nBytes;
    }

    public static String encodedString(ACell cell) {
        return Format.encodedBlob(cell).toHexString();
    }

    public static String encodedString(Object o) {
        return Format.encodedString(RT.cvm(o));
    }

    public static int estimateEncodingSize(ACell cell) {
        if (cell == null) {
            return 1;
        }
        return cell.estimatedEncodingSize();
    }

    public static ACell[] decodeCells(Blob data) throws BadFormatException {
        long ml = data.count();
        if (ml > 10000000L) {
            throw new BadFormatException("Message too long: " + ml);
        }
        if (ml == 0L) {
            return ACell.EMPTY_ARRAY;
        }
        ArrayList cells = new ArrayList();
        int pos = 0;
        while ((long)pos < ml) {
            Object result = Format.read(data, pos);
            pos += Format.getEncodingLength(result);
            ((ACell)result).getRef().getHash();
            cells.add(result);
        }
        return (ACell[])cells.toArray(ACell[]::new);
    }

    public static <T extends ACell> T decodeMultiCell(Blob data) throws BadFormatException {
        int rl;
        long ml = data.count();
        if (ml > 10000000L) {
            throw new BadFormatException("Message too long: " + ml);
        }
        if (ml < 1L) {
            throw new BadFormatException("Attempt to decode from empty Blob");
        }
        Object result = Format.read(data, 0);
        if (result == null) {
            return result;
        }
        int n = rl = result == null ? 1 : Utils.checkedInt(((ACell)result).getEncodingLength());
        if ((long)rl == ml) {
            return result;
        }
        final HashMap<Hash, Ref<T>> hm = new HashMap<Hash, Ref<T>>();
        int ix = rl;
        while ((long)ix < ml) {
            T c2 = Format.read(data, ix);
            if (c2 == null) {
                c2 = Format.read(data, ix);
                throw new BadFormatException("Null child encoding in Message");
            }
            if (((ACell)c2).isEmbedded()) {
                throw new BadFormatException("Embedded Cell provided in Message");
            }
            Hash h = ((ACell)c2).getHash();
            Ref<T> cr = Ref.get(c2);
            hm.put(h, cr);
            ix += ((ACell)c2).getEncodingLength();
        }
        final HashMap done = new HashMap();
        final ArrayList al = new ArrayList();
        IRefFunction func = new IRefFunction(){

            @Override
            public Ref<?> apply(Ref<?> r) {
                if (r.isEmbedded()) {
                    Object cc = r.getValue();
                    if (cc == null) {
                        return r;
                    }
                    ACell nc = ((ACell)cc).updateRefs(this);
                    if (cc == nc) {
                        return r;
                    }
                    return nc.getRef();
                }
                Hash h = r.getHash();
                ACell doneVal = (ACell)done.get(h);
                if (doneVal != null) {
                    return doneVal.getRef();
                }
                Ref partRef = (Ref)hm.get(h);
                if (partRef != null) {
                    al.add(partRef.getValue());
                    return partRef;
                }
                return r;
            }
        };
        al.add(result);
        Trees.visitStack(al, c -> {
            Hash h = c.getHash();
            if (done.containsKey(h)) {
                return;
            }
            al.add(c);
            int pos = al.size();
            ACell nc = c.updateRefs(func);
            if (pos == al.size()) {
                done.put(h, nc);
            }
        });
        result = (ACell)done.get(((ACell)result).getHash());
        return result;
    }

    public static Blob encodeMultiCell(ACell a) {
        Blob topCellEncoding = Format.encodedBlob(a);
        if (a.getRefCount() == 0) {
            return topCellEncoding;
        }
        ArrayList cells = new ArrayList();
        Consumer<Ref<?>> addToStackFunc = r -> cells.add(r);
        Refs.visitNonEmbedded(a, addToStackFunc);
        if (cells.isEmpty()) {
            return topCellEncoding;
        }
        int[] ml = new int[]{topCellEncoding.size()};
        HashSet refs = new HashSet();
        Trees.visitStack(cells, cr -> {
            if (!refs.contains(cr)) {
                Object c = cr.getValue();
                int cellLength = ((ACell)c).getEncodingLength();
                int newLength = ml[0] + cellLength;
                if ((long)newLength > 10000000L) {
                    return;
                }
                ml[0] = newLength;
                refs.add(cr);
                Refs.visitNonEmbedded(c, addToStackFunc);
            }
        });
        int messageLength = ml[0];
        byte[] msg = new byte[messageLength];
        topCellEncoding.getBytes(msg, 0);
        int ix = Utils.checkedInt(topCellEncoding.count());
        for (Ref r2 : refs) {
            Object c = r2.getValue();
            Blob enc = Format.encodedBlob(c);
            enc.getBytes(msg, ix);
            ix = (int)((long)ix + enc.count());
        }
        if (ix != messageLength) {
            throw new Error("Bad message length expected " + ml[0] + " but was: " + ix);
        }
        return Blob.wrap(msg);
    }

    public static Blob encodeDelta(java.util.List<ACell> cells) {
        int n = cells.size();
        int ml = 0;
        for (int i = 0; i < n; ++i) {
            int clen = cells.get(i).getEncodingLength();
            ml += clen;
        }
        byte[] msg = new byte[ml];
        int ix = 0;
        for (int i = n - 1; i >= 0; --i) {
            Blob enc = cells.get(i).getEncoding();
            int elen = enc.size();
            enc.getBytes(msg, ix);
            ix += elen;
        }
        if (ix != ml) {
            throw new Error("Bad message length expected " + ml + " but was: " + ix);
        }
        return Blob.wrap(msg);
    }

    public static int getEncodingLength(ACell value) {
        if (value == null) {
            return 1;
        }
        return value.getEncodingLength();
    }

    public static long readLong(Blob blob, int offset, int length) throws BadFormatException {
        byte[] bs = blob.getInternalArray();
        long v = bs[offset += blob.getInternalOffset()];
        if (v == 0L) {
            if (length == 1) {
                throw new BadFormatException("Long encoding: 0x00 not valid");
            }
            if (bs[offset + 1] >= 0) {
                throw new BadFormatException("Excess 0x00 at start of Long encoding");
            }
        } else if (v == -1L && length > 1 && bs[offset + 1] < 0) {
            throw new BadFormatException("Excess 0xff at start of Long encoding");
        }
        v = v << 56 >> 56;
        for (int i = 1; i < length; ++i) {
            v = (v << 8) + ((long)bs[offset + i] & 0xFFL);
        }
        return v;
    }

    public static int getLongLength(long value) {
        if (value == 0L) {
            return 0;
        }
        if (value > 0L) {
            return 8 - (Bits.leadingZeros(value) - 1) / 8;
        }
        return 8 - (Bits.leadingOnes(value) - 1) / 8;
    }
}

