/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AHashMap;
import convex.core.data.ARecord;
import convex.core.data.ASet;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.BlobMap;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AFn;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Utils;
import java.util.Map;

public class AccountStatus
extends ARecord {
    private final long sequence;
    private final long balance;
    private final long memory;
    private final AHashMap<Symbol, ACell> environment;
    private final AHashMap<Symbol, AHashMap<ACell, ACell>> metadata;
    private final BlobMap<Address, ACell> holdings;
    private final Address controller;
    private final AccountKey publicKey;
    private static final Keyword[] ACCOUNT_KEYS = new Keyword[]{Keywords.SEQUENCE, Keywords.BALANCE, Keywords.ALLOWANCE, Keywords.ENVIRONMENT, Keywords.METADATA, Keywords.HOLDINGS, Keywords.CONTROLLER, Keywords.KEY};
    private static final RecordFormat FORMAT = RecordFormat.of(ACCOUNT_KEYS);
    private static final int HAS_SEQUENCE = 1 << (int)FORMAT.indexFor(Keywords.SEQUENCE).longValue();
    private static final int HAS_BALANCE = 1 << (int)FORMAT.indexFor(Keywords.BALANCE).longValue();
    private static final int HAS_ALLOWANCE = 1 << (int)FORMAT.indexFor(Keywords.ALLOWANCE).longValue();
    private static final int HAS_ENVIRONMENT = 1 << (int)FORMAT.indexFor(Keywords.ENVIRONMENT).longValue();
    private static final int HAS_METADATA = 1 << (int)FORMAT.indexFor(Keywords.METADATA).longValue();
    private static final int HAS_HOLDINGS = 1 << (int)FORMAT.indexFor(Keywords.HOLDINGS).longValue();
    private static final int HAS_CONTROLLER = 1 << (int)FORMAT.indexFor(Keywords.CONTROLLER).longValue();
    private static final int HAS_KEY = 1 << (int)FORMAT.indexFor(Keywords.KEY).longValue();

    private AccountStatus(long sequence, long balance, long memory, AHashMap<Symbol, ACell> environment, AHashMap<Symbol, AHashMap<ACell, ACell>> metadata, BlobMap<Address, ACell> holdings, Address controller, AccountKey publicKey) {
        super(FORMAT.count());
        this.sequence = sequence;
        this.balance = balance;
        this.memory = memory;
        this.environment = environment;
        this.metadata = metadata;
        this.holdings = holdings;
        this.controller = controller;
        this.publicKey = publicKey;
    }

    public static AccountStatus create(long sequence, long balance, AccountKey key) {
        return new AccountStatus(sequence, balance, 0L, null, null, null, null, key);
    }

    public static AccountStatus createGovernance(long balance) {
        return new AccountStatus(0L, balance, 0L, null, null, null, null, null);
    }

    public static AccountStatus createActor() {
        return new AccountStatus(0L, 0L, 0L, null, null, null, null, null);
    }

    public static AccountStatus create(long balance, AccountKey key) {
        return AccountStatus.create(0L, balance, key);
    }

    public static AccountStatus create() {
        return AccountStatus.create(0L, 0L, null);
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getBalance() {
        return this.balance;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -63;
        return this.encodeRaw(bs, pos);
    }

    private int getInclusion() {
        int included = 0;
        if (this.sequence != 0L) {
            included |= HAS_SEQUENCE;
        }
        if (this.balance != 0L) {
            included |= HAS_BALANCE;
        }
        if (this.memory != 0L) {
            included |= HAS_ALLOWANCE;
        }
        if (this.environment != null) {
            included |= HAS_ENVIRONMENT;
        }
        if (this.metadata != null) {
            included |= HAS_METADATA;
        }
        if (this.holdings != null) {
            included |= HAS_HOLDINGS;
        }
        if (this.controller != null) {
            included |= HAS_CONTROLLER;
        }
        if (this.publicKey != null) {
            included |= HAS_KEY;
        }
        return included;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int included = this.getInclusion();
        bs[pos++] = (byte)included;
        if ((included & HAS_SEQUENCE) != 0) {
            pos = Format.writeVLCLong(bs, pos, this.sequence);
        }
        if ((included & HAS_BALANCE) != 0) {
            pos = Format.writeVLCLong(bs, pos, this.balance);
        }
        if ((included & HAS_ALLOWANCE) != 0) {
            pos = Format.writeVLCLong(bs, pos, this.memory);
        }
        if ((included & HAS_ENVIRONMENT) != 0) {
            pos = Format.write(bs, pos, this.environment);
        }
        if ((included & HAS_METADATA) != 0) {
            pos = Format.write(bs, pos, this.metadata);
        }
        if ((included & HAS_HOLDINGS) != 0) {
            pos = Format.write(bs, pos, this.holdings);
        }
        if ((included & HAS_CONTROLLER) != 0) {
            pos = Format.write(bs, pos, this.controller);
        }
        if ((included & HAS_KEY) != 0) {
            pos = this.publicKey.getBytes(bs, pos);
        }
        return pos;
    }

    public static AccountStatus read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        byte included = b.byteAt(epos++);
        long sequence = 0L;
        if ((included & HAS_SEQUENCE) != 0) {
            sequence = Format.readVLCLong(b, epos);
            epos += Format.getVLCLength(sequence);
        }
        long balance = 0L;
        if ((included & HAS_BALANCE) != 0) {
            balance = Format.readVLCLong(b, epos);
            epos += Format.getVLCLength(balance);
        }
        long allowance = 0L;
        if ((included & HAS_ALLOWANCE) != 0) {
            allowance = Format.readVLCLong(b, epos);
            epos += Format.getVLCLength(allowance);
        }
        AHashMap environment = null;
        if ((included & HAS_ENVIRONMENT) != 0) {
            environment = (AHashMap)Format.read(b, epos);
            if (environment == null || environment.isEmpty()) {
                throw new BadFormatException("Empty environment included!");
            }
            epos += environment.getEncodingLength();
        }
        AHashMap metadata = null;
        if ((included & HAS_METADATA) != 0) {
            metadata = (AHashMap)Format.read(b, epos);
            if (metadata == null || metadata.isEmpty()) {
                throw new BadFormatException("Empty metadata included!");
            }
            epos += metadata.getEncodingLength();
        }
        BlobMap holdings = null;
        if ((included & HAS_HOLDINGS) != 0) {
            holdings = (BlobMap)Format.read(b, epos);
            if (holdings == null || holdings.isEmpty()) {
                throw new BadFormatException("Empty holdings included!");
            }
            epos += holdings.getEncodingLength();
        }
        Address controller = null;
        if ((included & HAS_CONTROLLER) != 0) {
            controller = (Address)Format.read(b, epos);
            if (controller == null) {
                throw new BadFormatException("Empty controller included!");
            }
            epos += controller.getEncodingLength();
        }
        AccountKey publicKey = null;
        if ((included & HAS_KEY) != 0) {
            publicKey = AccountKey.readRaw(b, epos);
            epos += 32;
        }
        AccountStatus result = new AccountStatus(sequence, balance, allowance, environment, metadata, holdings, controller, publicKey);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 30 + Format.estimateEncodingSize(this.environment) + Format.estimateEncodingSize(this.holdings) + Format.estimateEncodingSize(this.controller) + 33;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public boolean isActor() {
        return this.publicKey == null;
    }

    public Address getController() {
        return this.controller;
    }

    public AccountStatus withBalance(long newBalance) {
        if (this.balance == newBalance) {
            return this;
        }
        return new AccountStatus(this.sequence, newBalance, this.memory, this.environment, this.metadata, this.holdings, this.controller, this.publicKey);
    }

    public AccountStatus withAccountKey(AccountKey newKey) {
        if (newKey == this.publicKey) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, this.environment, this.metadata, this.holdings, this.controller, newKey);
    }

    public AccountStatus withMemory(long newMemory) {
        if (this.memory == newMemory) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, newMemory, this.environment, this.metadata, this.holdings, this.controller, this.publicKey);
    }

    public AccountStatus withBalances(long newBalance, long newAllowance) {
        if (this.balance == newBalance && this.memory == newAllowance) {
            return this;
        }
        return new AccountStatus(this.sequence, newBalance, newAllowance, this.environment, this.metadata, this.holdings, this.controller, this.publicKey);
    }

    public AccountStatus withEnvironment(AHashMap<Symbol, ACell> newEnvironment) {
        if (newEnvironment != null && newEnvironment.isEmpty()) {
            newEnvironment = null;
        }
        if (this.environment == newEnvironment) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, newEnvironment, this.metadata, this.holdings, this.controller, this.publicKey);
    }

    public AccountStatus withMetadata(AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta) {
        if (newMeta != null && newMeta.isEmpty()) {
            newMeta = null;
        }
        if (this.metadata == newMeta) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, this.environment, newMeta, this.holdings, this.controller, this.publicKey);
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof AccountStatus)) {
            return false;
        }
        AccountStatus as = (AccountStatus)a;
        return this.equals(as);
    }

    public boolean equals(AccountStatus a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.balance != a.balance) {
            return false;
        }
        if (this.sequence != a.sequence) {
            return false;
        }
        if (this.memory != a.memory) {
            return false;
        }
        if (!Utils.equals(this.publicKey, a.publicKey)) {
            return false;
        }
        if (!Utils.equals(this.controller, a.controller)) {
            return false;
        }
        if (!Utils.equals(this.holdings, a.holdings)) {
            return false;
        }
        if (!Utils.equals(this.metadata, a.metadata)) {
            return false;
        }
        return Utils.equals(this.environment, a.environment);
    }

    public AccountStatus updateSequence(long newSequence) {
        if (this.isActor()) {
            throw new Error("Trying to update Actor sequence number!");
        }
        long expected = this.sequence + 1L;
        if (expected != newSequence) {
            return null;
        }
        return new AccountStatus(newSequence, this.balance, this.memory, this.environment, this.metadata, this.holdings, this.controller, this.publicKey);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.environment != null) {
            if (this.environment.isEmpty()) {
                throw new InvalidDataException("Account should not have empty map as environment", this);
            }
            this.environment.validateCell();
        }
        if (this.holdings != null) {
            if (this.holdings.isEmpty()) {
                throw new InvalidDataException("Account should not have empty map as holdings", this);
            }
            this.holdings.validateCell();
        }
    }

    public <R> R getEnvironmentValue(Symbol symbol) {
        if (this.environment == null) {
            return null;
        }
        Object value = this.environment.get(symbol);
        return (R)value;
    }

    public BlobMap<Address, ACell> getHoldings() {
        BlobMap<Address, ACell> result = this.holdings;
        if (result == null) {
            return (BlobMap)BlobMaps.empty();
        }
        return result;
    }

    public ACell getHolding(Address addr) {
        if (this.holdings == null) {
            return null;
        }
        return this.holdings.get(addr);
    }

    public AccountStatus withHolding(Address addr, ACell value) {
        ABlobMap newHoldings = this.getHoldings();
        newHoldings = value == null ? (BlobMap)newHoldings.dissoc(addr) : (newHoldings == null ? (BlobMap)BlobMaps.of(addr, value) : newHoldings.assoc(addr, value));
        return this.withHoldings((BlobMap<Address, ACell>)newHoldings);
    }

    private AccountStatus withHoldings(BlobMap<Address, ACell> newHoldings) {
        if (newHoldings.isEmpty()) {
            newHoldings = null;
        }
        if (this.holdings == newHoldings) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, this.environment, this.metadata, newHoldings, this.controller, this.publicKey);
    }

    public AccountStatus withController(Address newController) {
        if (this.controller == newController) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, this.environment, this.metadata, this.holdings, newController, this.publicKey);
    }

    @Override
    public int getRefCount() {
        int rc = this.environment == null ? 0 : this.environment.getRefCount();
        rc += this.metadata == null ? 0 : this.metadata.getRefCount();
        return rc += this.holdings == null ? 0 : this.holdings.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int hc;
        int mc;
        int ec;
        if (i < 0) {
            throw new IndexOutOfBoundsException(i);
        }
        int n = ec = this.environment == null ? 0 : this.environment.getRefCount();
        if (i < ec) {
            return this.environment.getRef(i);
        }
        int n2 = mc = this.metadata == null ? 0 : this.metadata.getRefCount();
        if ((i -= ec) < mc) {
            return this.metadata.getRef(i);
        }
        int n3 = hc = this.holdings == null ? 0 : this.holdings.getRefCount();
        if ((i -= mc) < hc) {
            return this.holdings.getRef(i);
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.BALANCE.equals(key)) {
            return CVMLong.create(this.balance);
        }
        if (Keywords.ALLOWANCE.equals(key)) {
            return CVMLong.create(this.memory);
        }
        if (Keywords.ENVIRONMENT.equals(key)) {
            return this.environment;
        }
        if (Keywords.METADATA.equals(key)) {
            return this.metadata;
        }
        if (Keywords.HOLDINGS.equals(key)) {
            return this.getHoldings();
        }
        if (Keywords.CONTROLLER.equals(key)) {
            return this.controller;
        }
        if (Keywords.KEY.equals(key)) {
            return this.publicKey;
        }
        return null;
    }

    @Override
    public byte getTag() {
        return -63;
    }

    @Override
    public AccountStatus updateRefs(IRefFunction func) {
        AHashMap<Symbol, ACell> newEnv = Ref.updateRefs(this.environment, func);
        AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta = Ref.updateRefs(this.metadata, func);
        BlobMap<Address, ACell> newHoldings = Ref.updateRefs(this.holdings, func);
        if (newEnv == this.environment && newMeta == this.metadata && newHoldings == this.holdings) {
            return this;
        }
        return new AccountStatus(this.sequence, this.balance, this.memory, newEnv, newMeta, newHoldings, this.controller, this.publicKey);
    }

    public long getMemory() {
        return this.memory;
    }

    public long getMemoryUsage() {
        return this.getMemorySize();
    }

    public AccountStatus addBalance(long delta) {
        if (delta == 0L) {
            return this;
        }
        return this.withBalance(this.balance + delta);
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public AHashMap<Symbol, AHashMap<ACell, ACell>> getMetadata() {
        if (this.metadata == null) {
            return Maps.empty();
        }
        return this.metadata;
    }

    public AHashMap<Symbol, ACell> getEnvironment() {
        if (this.environment == null) {
            return Maps.empty();
        }
        return this.environment;
    }

    public ASet<Symbol> getCallableFunctions() {
        ACollection results = Sets.empty();
        if (this.metadata == null) {
            return results;
        }
        for (Map.Entry me : this.metadata.entrySet()) {
            Symbol sym;
            Object callVal = ((AHashMap)me.getValue()).get(Keywords.CALLABLE_Q);
            if (!RT.bool(callVal) || RT.ensureFunction((ACell)this.getEnvironmentValue(sym = (Symbol)me.getKey())) == null) continue;
            results = ((ASet)results).conj(sym);
        }
        return results;
    }

    public <R extends ACell> AFn<R> getCallableFunction(Symbol sym) {
        ACell exported = (ACell)this.getEnvironmentValue(sym);
        if (exported == null) {
            return null;
        }
        AFn fn = RT.ensureFunction(exported);
        if (fn == null) {
            return null;
        }
        AHashMap md = (AHashMap)this.getMetadata().get(sym);
        if (RT.bool(md.get(Keywords.CALLABLE_Q))) {
            return fn;
        }
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

