/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public abstract class ALongBlob
extends ABlob {
    protected static final int LENGTH = 8;
    protected static final int HEX_LENGTH = 16;
    protected final long value;

    protected ALongBlob(long value) {
        this.value = value;
    }

    @Override
    public final long count() {
        return 8L;
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ALongBlob> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 16);
        return newRef;
    }

    @Override
    public boolean appendHex(BlobBuilder bb, long length) {
        long n = Math.min(length, 16L);
        int i = 0;
        while ((long)i < n) {
            bb.append(Utils.toHexChar(this.getHexDigit(i)));
            ++i;
        }
        return n == 16L;
    }

    @Override
    public int getHexDigit(long i) {
        if (i < 0L || i >= 16L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return 0xF & (int)(this.value >> (int)((16L - i - 1L) * 4L));
    }

    @Override
    public abstract ABlob slice(long var1, long var3);

    @Override
    public abstract Blob toFlatBlob();

    @Override
    public long commonHexPrefixLength(ABlob b) {
        return this.toFlatBlob().commonHexPrefixLength(b);
    }

    private void checkIndex(long i) {
        if (i < 0L || i >= 8L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
    }

    @Override
    public final byte byteAt(long i) {
        this.checkIndex(i);
        return (byte)(this.value >> (int)((8L - i - 1L) * 8L));
    }

    @Override
    public final byte byteAtUnchecked(long i) {
        return (byte)(this.value >> (int)((8L - i - 1L) * 8L));
    }

    @Override
    public final ABlob append(ABlob d) {
        return this.toFlatBlob().append(d);
    }

    @Override
    public abstract boolean equals(ABlob var1);

    @Override
    public final int getBytes(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.value);
        return pos;
    }

    @Override
    public final Blob getChunk(long i) {
        if (i == 0L) {
            return (Blob)this.getCanonical();
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        return this.toFlatBlob().getByteBuffer();
    }

    @Override
    protected final long calcMemorySize() {
        return 0L;
    }

    @Override
    public long hexMatchLength(ABlob b, long start, long length) {
        return this.toFlatBlob().hexMatchLength(b, start, length);
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public long toExactLong() {
        return this.value;
    }

    @Override
    public int compareTo(ABlob b) {
        if (b.count() == 8L) {
            return this.compareTo(b.toExactLong());
        }
        return -b.compareTo(this);
    }

    @Override
    protected int compareTo(long bvalue) {
        return Long.compareUnsigned(this.value, bvalue);
    }

    @Override
    public final boolean equalsBytes(ABlob b) {
        if (b.count() != 8L) {
            return false;
        }
        return this.value == b.toExactLong();
    }

    @Override
    public abstract byte getTag();

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final int getRefCount() {
        return 0;
    }

    @Override
    public final boolean isEmbedded() {
        return true;
    }
}

