/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Result;
import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Utils;

public class BlockResult
extends ARecord {
    private State state;
    private AVector<Result> results;
    private static final Keyword[] BLOCKRESULT_KEYS = new Keyword[]{Keywords.STATE, Keywords.RESULTS};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCKRESULT_KEYS);

    private BlockResult(State state, AVector<Result> results) {
        super(FORMAT.count());
        this.state = state;
        this.results = results;
    }

    public static BlockResult create(State state, Result[] results) {
        int n = results.length;
        Object[] rs = new Object[n];
        for (int i = 0; i < n; ++i) {
            rs[i] = results[i];
        }
        return new BlockResult(state, Vectors.of(rs));
    }

    public static BlockResult create(State state, AVector<Result> results) {
        return new BlockResult(state, results);
    }

    public State getState() {
        return this.state;
    }

    public AVector<Result> getResults() {
        return this.results;
    }

    public boolean isError(long i) {
        return this.getResult(i).isError();
    }

    public Result getResult(long i) {
        if (i < 0L || i >= this.results.count()) {
            return null;
        }
        return this.results.get(i);
    }

    public ACell getErrorCode(long i) {
        Result result = this.getResult(i);
        return result.getErrorCode();
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.STATE.equals(key)) {
            return this.state;
        }
        if (Keywords.RESULTS.equals(key)) {
            return this.results;
        }
        return null;
    }

    @Override
    public byte getTag() {
        return -82;
    }

    @Override
    public BlockResult updateRefs(IRefFunction func) {
        State newState = this.state.updateRefs(func);
        ACell newResults = this.results.updateRefs(func);
        return BlockResult.create(newState, (AVector<Result>)newResults);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.results.validate();
        this.state.validate();
        long n = this.results.count();
        for (long i = 0L; i < n; ++i) {
            Result r = this.results.get(i);
            if (r instanceof Result) continue;
            throw new InvalidDataException("Not a Result at position " + i + " - found " + Utils.getClassName(r), this);
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.state.encode(bs, pos);
        pos = this.results.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.state.estimatedEncodingSize() + this.results.estimatedEncodingSize();
    }

    public static BlockResult read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        State newState = (State)Format.read(b, epos);
        if (newState == null) {
            throw new BadFormatException("Null state");
        }
        AVector newResults = (AVector)Format.read(b, epos += Format.getEncodingLength(newState));
        if (newResults == null) {
            throw new BadFormatException("Null results");
        }
        BlockResult result = BlockResult.create(newState, newResults);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(newResults)));
        return result;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof BlockResult)) {
            return false;
        }
        BlockResult as = (BlockResult)a;
        return this.equals(as);
    }

    public boolean equals(BlockResult a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        if (!Utils.equals(this.results, a.results)) {
            return false;
        }
        return Utils.equals(this.state, a.state);
    }

    @Override
    public int getRefCount() {
        return this.state.getRefCount() + this.results.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int sc = Utils.refCount(this.state);
        if (i < sc) {
            return this.state.getRef(i);
        }
        return this.results.getRef(i - sc);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

