/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import java.util.WeakHashMap;

public class LoadMonitor {
    private static final WeakHashMap<Thread, LoadMetrics> loads = new WeakHashMap();

    private static LoadMetrics createValue() {
        long ts;
        LoadMetrics lm = new LoadMetrics();
        lm.last = ts = System.currentTimeMillis();
        return lm;
    }

    public static double getLoad(Thread t) {
        LoadMetrics lm = LoadMonitor.get(t);
        return lm.load;
    }

    public static void up() {
        Thread t = Thread.currentThread();
        LoadMetrics lm = LoadMonitor.get(t);
        long ts = System.currentTimeMillis();
        lm.update(true, ts);
    }

    public static void down() {
        Thread t = Thread.currentThread();
        LoadMetrics lm = LoadMonitor.get(t);
        long ts = System.currentTimeMillis();
        lm.update(false, ts);
    }

    public static LoadMetrics get(Thread t) {
        LoadMetrics lm = loads.get(t);
        if (lm == null) {
            lm = LoadMonitor.createValue();
            loads.put(t, lm);
        }
        return lm;
    }

    private static class LoadMetrics {
        long last = 0L;
        boolean isUp = false;
        double load = 0.0;

        private LoadMetrics() {
        }

        public void update(boolean up, long ts) {
            long elapsed = ts - this.last;
            double decay = Math.pow(0.5, (double)elapsed * 0.001);
            this.load = this.load * decay + (1.0 - decay) * (this.isUp ? 1.0 : 0.0);
            this.last = ts;
            this.isUp = up;
        }
    }
}

