/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;

public class Multi
extends ATransaction {
    protected Ref<AVector<ATransaction>> txs;
    private int mode;
    public static final int MODE_ANY = 0;
    public static final int MODE_ALL = 1;
    public static final int MODE_FIRST = 2;
    public static final int MODE_UNTIL = 3;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.MODE, Keywords.TXS};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    protected Multi(Address origin, long sequence, int mode, Ref<AVector<ATransaction>> txs) {
        super(FORMAT.count(), origin, sequence);
        this.mode = mode;
        this.txs = txs;
    }

    public static Multi create(Address origin, long sequence, int mode, ATransaction ... txs) {
        AVector v = Vectors.create(txs);
        return new Multi(origin, sequence, mode, v.getRef());
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -45;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = Format.writeVLCLong(bs, pos, this.mode);
        pos = this.txs.encode(bs, pos);
        return pos;
    }

    public static Multi read(Blob b, int pos) throws BadFormatException {
        long sequence;
        long mode;
        int epos = pos + 1;
        long aval = Format.readVLCLong(b, epos);
        Address origin = Address.create(aval);
        epos += Format.getVLCLength(aval);
        if (!Multi.isValidMode(mode = Format.readVLCLong(b, epos += Format.getVLCLength(sequence = Format.readVLCLong(b, epos))))) {
            throw new BadFormatException("Invalid Multi transaction mode: " + mode);
        }
        Ref<AVector<ATransaction>> txs = Format.readRef(b, epos += Format.getVLCLength(mode));
        epos = (int)((long)epos + txs.getEncodingLength());
        Multi result = new Multi(origin, sequence, (int)mode, txs);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    private static boolean isValidMode(long mode) {
        return mode >= 0L && mode <= 3L;
    }

    @Override
    public int estimatedEncodingSize() {
        return 170;
    }

    @Override
    public <T extends ACell> Context<T> apply(Context<?> ctx) {
        Context rctx;
        Context ictx = ctx.fork();
        AVector<ATransaction> ts = this.txs.getValue();
        long n = ts.count();
        ASequence rs = Vectors.empty();
        int i = 0;
        while ((long)i < n) {
            ATransaction t = (ATransaction)ts.get(i);
            ctx = this.applySubTransaction(ctx, t);
            Result r = Result.fromContext(ctx);
            rs = rs.conj(r);
            if (r.isError() ? this.mode == 3 || this.mode == 1 : this.mode == 2) break;
            ++i;
        }
        if (ctx.isError() && this.mode == 1) {
            ctx = ictx.handleStateResults(ctx, true);
            rctx = ctx.withError(ErrorCodes.CHILD, rs);
        } else {
            rctx = ctx.withResult(rs);
        }
        return rctx;
    }

    private Context<?> applySubTransaction(Context<?> ctx, ATransaction t) {
        Address torigin = t.origin;
        if (!this.origin.equals(torigin)) {
            AccountStatus as = ctx.getAccountStatus(torigin);
            if (as == null) {
                return ctx.withError(ErrorCodes.NOBODY, "Child transaction origin account does not exist");
            }
            Address cont = as.getController();
            if (cont == null || !this.origin.equals(cont)) {
                return ctx.withError(ErrorCodes.TRUST, "Account control not available");
            }
        }
        Context<Object> childContext = ctx.forkWithAddress(torigin);
        childContext = t.apply(childContext);
        ctx = ctx.handleStateResults(childContext, false);
        return ctx;
    }

    @Override
    public Long getMaxJuice() {
        return 1000000L;
    }

    @Override
    public ATransaction withSequence(long newSequence) {
        if (this.sequence == newSequence) {
            return this;
        }
        return new Multi(this.origin, newSequence, this.mode, this.txs);
    }

    @Override
    public ATransaction withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return new Multi(newAddress, this.sequence, this.mode, this.txs);
    }

    @Override
    public byte getTag() {
        return -45;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.mode < 0 || this.mode > 3) {
            throw new InvalidDataException("Illegal mode: " + this.mode, this);
        }
    }

    @Override
    public ACell get(ACell key) {
        if (Keywords.ORIGIN.equals(key)) {
            return this.origin;
        }
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.MODE.equals(key)) {
            return CVMLong.create(this.mode);
        }
        if (Keywords.TXS.equals(key)) {
            return this.txs.getValue();
        }
        return null;
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i == 0) {
            return this.txs;
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public Multi updateRefs(IRefFunction func) {
        Ref<AVector<ATransaction>> ntxs = func.apply(this.txs);
        if (ntxs == this.txs) {
            return this;
        }
        return new Multi(this.origin, this.sequence, this.mode, ntxs);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

