/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.ErrorCodes;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.ops.Constant;
import java.nio.ByteBuffer;

public class Lookup<T extends ACell>
extends AOp<T> {
    private final AOp<Address> address;
    private final Symbol symbol;

    private Lookup(AOp<Address> address, Symbol symbol) {
        this.address = address;
        this.symbol = symbol;
    }

    public static <T extends ACell> Lookup<T> create(AOp<Address> address, Symbol form) {
        return new Lookup<T>(address, form);
    }

    public static <T extends ACell> Lookup<T> create(AOp<Address> address, String name) {
        return Lookup.create(address, Symbol.create(name));
    }

    public static <T extends ACell> Lookup<T> create(Address addr, Symbol sym) {
        return Lookup.create(Constant.of(addr), sym);
    }

    public static <T extends ACell> Lookup<T> create(Symbol symbol) {
        return Lookup.create((AOp<Address>)null, symbol);
    }

    public static <T extends ACell> Lookup<T> create(String name) {
        return Lookup.create(Symbol.create(name));
    }

    @Override
    public <I extends ACell> Context<T> execute(Context<I> context) {
        Context<Object> rctx = context;
        Address namespaceAddress = null;
        if (this.address != null) {
            if ((rctx = rctx.execute(this.address)).isExceptional()) {
                return rctx;
            }
            Object maybeAddress = rctx.getResult();
            namespaceAddress = RT.ensureAddress((ACell)maybeAddress);
            if (namespaceAddress == null) {
                return rctx.withError(ErrorCodes.CAST, "Lookup requires Address but got: " + RT.getType((ACell)maybeAddress));
            }
        }
        namespaceAddress = this.address == null ? context.getAddress() : namespaceAddress;
        return rctx.lookupDynamic(namespaceAddress, this.symbol).consumeJuice(40L);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        if (this.address != null) {
            if (!this.address.print(bb, limit)) {
                return false;
            }
            bb.append('/');
        }
        return this.symbol.print(bb, limit);
    }

    @Override
    public byte opCode() {
        return 5;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.symbol.encode(bs, pos);
        pos = Format.write(bs, pos, this.address);
        return pos;
    }

    public static <T extends ACell> Lookup<T> read(ByteBuffer bb) throws BadFormatException {
        Symbol sym = (Symbol)Format.read(bb);
        if (sym == null) {
            throw new BadFormatException("Lookup symbol cannot be null");
        }
        AOp address = (AOp)Format.read(bb);
        return Lookup.create((AOp<Address>)address, sym);
    }

    public static <T extends ACell> Lookup<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        Symbol sym = (Symbol)Format.read(b, epos);
        if (sym == null) {
            throw new BadFormatException("Lookup symbol cannot be null");
        }
        AOp address = (AOp)Format.read(b, epos += Format.getEncodingLength(sym));
        Lookup<T> result = Lookup.create((AOp<Address>)address, sym);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(address)));
        return result;
    }

    @Override
    public int getRefCount() {
        if (this.address == null) {
            return 0;
        }
        return this.address.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (this.address == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.address.getRef(i);
    }

    @Override
    public Lookup<T> updateRefs(IRefFunction func) {
        if (this.address == null) {
            return this;
        }
        ACell newAddress = this.address.updateRefs(func);
        if (this.address == newAddress) {
            return this;
        }
        return Lookup.create((AOp<Address>)newAddress, this.symbol);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.address != null) {
            this.address.validateCell();
        }
        this.symbol.validateCell();
    }

    public AOp<Address> getAddress() {
        return this.address;
    }
}

