/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.BlobMap;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class BlobMaps {
    public static <R extends ABlobMap<K, V>, K extends ABlob, V extends ACell> R empty() {
        return (R)BlobMap.EMPTY;
    }

    public static <R extends ABlobMap<K, V>, K extends ABlob, V extends ACell> R create(K k, V v) {
        return (R)BlobMap.create(k, v);
    }

    public static <R extends ABlobMap<K, V>, K extends ABlob, V extends ACell> R of(Object ... kvs) {
        int n = kvs.length;
        if (Utils.isOdd(n)) {
            throw new IllegalArgumentException("Even number of key + values required");
        }
        ABlobMap result = (BlobMap)BlobMaps.empty();
        for (int i = 0; i < n; i += 2) {
            Object value = RT.cvm(kvs[i + 1]);
            result = result.assoc((ABlob)kvs[i], (ACell)value);
        }
        return (R)result;
    }

    public static <R extends ABlobMap<K, V>, K extends ABlob, V extends ACell> R create(HashMap<K, V> map) {
        ABlobMap result = (BlobMap)BlobMaps.empty();
        for (Map.Entry<K, V> me : map.entrySet()) {
            result = result.assoc((ACell)me.getKey(), (ACell)me.getValue());
        }
        return (R)result;
    }
}

