/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import java.nio.ByteBuffer;

public class Order
extends ARecord {
    private final Ref<AVector<SignedData<Block>>> blocks;
    private final long proposalPoint;
    private final long consensusPoint;
    private final long timestamp;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.BLOCKS, Keywords.CONSENSUS_POINT, Keywords.PROPOSAL_POINT, Keywords.TIMESTAMP};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    private Order(Ref<AVector<SignedData<Block>>> blocks, long proposalPoint, long consensusPoint, long timestamp) {
        super(FORMAT.count());
        this.blocks = blocks;
        this.consensusPoint = consensusPoint;
        this.proposalPoint = proposalPoint;
        this.timestamp = timestamp;
    }

    private static Order create(Ref<AVector<SignedData<Block>>> blocks, long proposalPoint, long consensusPoint, long timestamp) {
        return new Order(blocks, proposalPoint, consensusPoint, timestamp);
    }

    public static Order create(long proposalPoint, long consensusPoint, SignedData<Block> ... blocks) {
        return Order.create(Vectors.of(blocks).getRef(), proposalPoint, consensusPoint, 0L);
    }

    public static Order create() {
        return Order.create(Vectors.empty().getRef(), 0L, 0L, 0L);
    }

    private byte getRecordTag() {
        return -84;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getRecordTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.blocks.encode(bs, pos);
        pos = Format.writeVLCLong(bs, pos, this.proposalPoint);
        pos = Format.writeVLCLong(bs, pos, this.consensusPoint);
        pos = Format.writeVLCLong(bs, pos, this.timestamp);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.blocks.estimatedEncodingSize() + 30;
    }

    public static Order read(ByteBuffer bb) throws BadFormatException {
        Ref<AVector<SignedData<Block>>> blocks = Format.readRef(bb);
        if (blocks == null) {
            throw new BadFormatException("Null blocks in Order!");
        }
        long pp = Format.readVLCLong(bb);
        long cp = Format.readVLCLong(bb);
        long ts = Format.readVLCLong(bb);
        if (pp < cp) {
            throw new BadFormatException("Proposal point [" + pp + "] before consensus point [" + cp + "]");
        }
        return new Order(blocks, pp, cp, ts);
    }

    public static Order read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<AVector<SignedData<Block>>> blocks = Format.readRef(b, epos);
        if (blocks == null) {
            throw new BadFormatException("Null blocks in Order!");
        }
        epos = (int)((long)epos + blocks.getEncodingLength());
        long pp = Format.readVLCLong(b, epos);
        long cp = Format.readVLCLong(b, epos += Format.getVLCLength(pp));
        long ts = Format.readVLCLong(b, epos += Format.getVLCLength(cp));
        epos += Format.getVLCLength(ts);
        if (pp < cp) {
            throw new BadFormatException("Proposal point [" + pp + "] before consensus point [" + cp + "]");
        }
        Order result = new Order(blocks, pp, cp, ts);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    public boolean checkConsistent(Order bc) {
        long commonPrefix = this.getBlocks().commonPrefixLength(bc.getBlocks());
        return commonPrefix >= this.consensusPoint;
    }

    public long getConsensusPoint() {
        return this.consensusPoint;
    }

    public long getProposalPoint() {
        return this.proposalPoint;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AVector<SignedData<Block>> getBlocks() {
        return this.blocks.getValue();
    }

    public SignedData<Block> getBlock(long i) {
        return this.getBlocks().get(i);
    }

    public Order append(SignedData<Block> block) {
        AVector<SignedData<Block>> newBlocks = this.getBlocks().append(block);
        return Order.create(newBlocks.getRef(), this.proposalPoint, this.consensusPoint, this.timestamp);
    }

    public Order withBlocks(AVector<SignedData<Block>> newBlocks) {
        if (this.blocks.getValue() == newBlocks) {
            return this;
        }
        long nblocks = newBlocks.count();
        long newProposalPoint = Math.min(nblocks, this.proposalPoint);
        long newConsensusPoint = Math.min(nblocks, this.consensusPoint);
        return Order.create(newBlocks.getRef(), newProposalPoint, newConsensusPoint, this.timestamp);
    }

    public Order withTimestamp(long newTimestamp) {
        if (this.timestamp == newTimestamp) {
            return this;
        }
        return Order.create(this.blocks, this.proposalPoint, this.consensusPoint, newTimestamp);
    }

    public Order withProposalPoint(long newProposalPoint) {
        if (this.proposalPoint == newProposalPoint) {
            return this;
        }
        if (newProposalPoint < this.consensusPoint) {
            throw new IllegalArgumentException("Trying to move proposed consensus before confirmed consensus?! " + newProposalPoint);
        }
        if (newProposalPoint > this.getBlocks().count()) {
            throw new IndexOutOfBoundsException("Block index: " + newProposalPoint);
        }
        return new Order(this.blocks, newProposalPoint, this.consensusPoint, this.timestamp);
    }

    public Order withConsenusPoint(long newConsensusPoint) {
        if (this.consensusPoint == newConsensusPoint) {
            return this;
        }
        if (newConsensusPoint > this.getBlocks().count()) {
            throw new IndexOutOfBoundsException("Block index: " + newConsensusPoint);
        }
        long newProposalPoint = Math.max(this.proposalPoint, newConsensusPoint);
        return Order.create(this.blocks, newProposalPoint, newConsensusPoint, this.timestamp);
    }

    public long getBlockCount() {
        return this.getBlocks().count();
    }

    public Order withoutConsenus() {
        return Order.create(this.blocks, 0L, 0L, this.timestamp);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.blocks.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i == 0) {
            return this.blocks;
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public byte getTag() {
        return -84;
    }

    @Override
    public ACell get(ACell key) {
        if (Keywords.BLOCKS.equals(key)) {
            return this.getBlocks();
        }
        if (Keywords.CONSENSUS_POINT.equals(key)) {
            return CVMLong.create(this.consensusPoint);
        }
        if (Keywords.PROPOSAL_POINT.equals(key)) {
            return CVMLong.create(this.proposalPoint);
        }
        if (Keywords.TIMESTAMP.equals(key)) {
            return CVMLong.create(this.timestamp);
        }
        return null;
    }

    @Override
    public Order updateRefs(IRefFunction func) {
        Ref<AVector<SignedData<Block>>> newBlocks = func.apply(this.blocks);
        if (this.blocks == newBlocks) {
            return this;
        }
        return new Order(newBlocks, this.proposalPoint, this.consensusPoint, this.timestamp);
    }

    public boolean consensusEquals(Order b) {
        if (b == null) {
            return false;
        }
        if (this.proposalPoint != b.proposalPoint) {
            return false;
        }
        if (this.consensusPoint != b.consensusPoint) {
            return false;
        }
        return this.blocks.equals(b.blocks);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

