/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.Constants;
import convex.core.MergeContext;
import convex.core.Order;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlob;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.BlobMap;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keywords;
import convex.core.data.MapEntry;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Counters;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;

public class Belief
extends ARecord {
    private static final RecordFormat BELIEF_FORMAT = RecordFormat.of(Keywords.ORDERS);
    private final BlobMap<AccountKey, SignedData<Order>> orders;

    private Belief(BlobMap<AccountKey, SignedData<Order>> orders) {
        super(BELIEF_FORMAT.count());
        this.orders = orders;
    }

    @Override
    public ACell get(ACell k) {
        if (Keywords.ORDERS.equals(k)) {
            return this.orders;
        }
        return null;
    }

    @Override
    public Belief updateRefs(IRefFunction func) {
        BlobMap<AccountKey, SignedData<Order>> newOrders = Ref.updateRefs(this.orders, func);
        if (this.orders == newOrders) {
            return this;
        }
        return new Belief(newOrders);
    }

    public static Belief initial() {
        return Belief.create((BlobMap)BlobMaps.empty());
    }

    public static Belief create(AKeyPair kp, Order order) {
        BlobMap<AccountKey, SignedData<Order>> orders = BlobMap.of(kp.getAccountKey(), kp.signData(order));
        return Belief.create(orders);
    }

    private static Belief create(BlobMap<AccountKey, SignedData<Order>> orders, long timestamp) {
        return new Belief(orders);
    }

    public static Belief create(SignedData<Order> ... orders) {
        ABlobMap newOrders = (BlobMap)BlobMaps.empty();
        for (SignedData<Order> so : orders) {
            newOrders = newOrders.assoc(so.getAccountKey(), so);
        }
        return new Belief((BlobMap<AccountKey, SignedData<Order>>)newOrders);
    }

    public static Belief create(HashMap<AccountKey, SignedData<Order>> orderMap) {
        BlobMap orders = (BlobMap)BlobMaps.create(orderMap);
        return new Belief(orders);
    }

    private static Belief create(BlobMap<AccountKey, SignedData<Order>> orders) {
        return Belief.create(orders, Constants.INITIAL_TIMESTAMP);
    }

    public static Belief createSingleOrder(AKeyPair kp) {
        AccountKey address = kp.getAccountKey();
        SignedData<Order> order = kp.signData(Order.create());
        return Belief.create(BlobMap.of(address, order));
    }

    public Belief merge(MergeContext mc, Belief ... beliefs) throws InvalidDataException {
        ++Counters.beliefMerge;
        BlobMap<AccountKey, SignedData<Order>> accOrders = this.accumulateOrders(mc, beliefs);
        BlobMap<AccountKey, SignedData<Order>> resultOrders = this.vote(mc, accOrders);
        if (resultOrders == null) {
            return this;
        }
        if (this.orders == resultOrders) {
            return this;
        }
        Belief result = new Belief(resultOrders);
        return result;
    }

    private BlobMap<AccountKey, SignedData<Order>> accumulateOrders(MergeContext mc, Belief[] beliefs) {
        BlobMap<AccountKey, SignedData<Order>> result = this.orders;
        for (Belief belief : beliefs) {
            if (belief == null) continue;
            result = this.accumulateOrders(mc, result, belief);
        }
        return result;
    }

    public Belief mergeOrders(MergeContext mc, Belief b) {
        BlobMap<AccountKey, SignedData<Order>> newOrders = this.accumulateOrders(mc, this.orders, b);
        return this.withOrders(newOrders);
    }

    private BlobMap<AccountKey, SignedData<Order>> accumulateOrders(MergeContext mc, BlobMap<AccountKey, SignedData<Order>> orders, Belief belief) {
        AMap result = orders;
        BlobMap<AccountKey, SignedData<Order>> bOrders = belief.orders;
        long bcount = bOrders.count();
        for (long i = 0L; i < bcount; ++i) {
            Order ac;
            boolean shouldReplace;
            Order bc;
            MapEntry<AccountKey, SignedData<Order>> be = bOrders.entryAt(i);
            ABlob key = (ABlob)be.getKey();
            SignedData b = (SignedData)be.getValue();
            if (b == null || (bc = (Order)b.getValue()).getTimestamp() > mc.getTimestamp()) continue;
            SignedData<Order> a = ((BlobMap)result).get(key);
            if (a == null) {
                result = ((BlobMap)result).assocEntry((MapEntry)be);
                continue;
            }
            if (a.equals(b) || !(shouldReplace = Belief.compareOrders(ac = a.getValue(), bc))) continue;
            result = ((BlobMap)result).assocEntry((MapEntry)be);
        }
        return result;
    }

    public static boolean compareOrders(Order oldOrder, Order newOrder) {
        if (newOrder == null) {
            return false;
        }
        if (oldOrder == null) {
            return true;
        }
        int tsComp = Long.compare(oldOrder.getTimestamp(), newOrder.getTimestamp());
        if (tsComp > 0) {
            return false;
        }
        if (tsComp < 0) {
            return true;
        }
        if (newOrder.getConsensusPoint() > oldOrder.getConsensusPoint()) {
            return true;
        }
        if (newOrder.getProposalPoint() > oldOrder.getProposalPoint()) {
            return true;
        }
        AVector<SignedData<Block>> abs = oldOrder.getBlocks();
        AVector<SignedData<Block>> bbs = newOrder.getBlocks();
        return abs.count() < bbs.count();
    }

    private BlobMap<AccountKey, SignedData<Order>> vote(MergeContext mc, BlobMap<AccountKey, SignedData<Order>> accOrders) {
        double consideredStake;
        AccountKey myAddress = mc.getAccountKey();
        Order myOrder = this.getMyOrder(mc);
        assert (myOrder != null);
        State votingState = mc.getConsensusState();
        AMap filteredOrders = accOrders.filterValues((T signedOrder) -> {
            try {
                Order otherOrder = (Order)signedOrder.getValue();
                return myOrder.checkConsistent(otherOrder);
            }
            catch (Exception e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
        });
        long consensusPoint = myOrder.getConsensusPoint();
        BlobMap<AccountKey, PeerStatus> peers = votingState.getPeers();
        HashMap<AccountKey, Double> weightedStakes = votingState.computeStakes();
        double totalStake = weightedStakes.get(null);
        HashMap<Order, Double> stakedOrders = new HashMap<Order, Double>(peers.size());
        AVector<SignedData<Block>> winningBlocks = Belief.computeWinningOrder(stakedOrders, consensusPoint, consideredStake = Belief.prepareStakedOrders(filteredOrders, weightedStakes, stakedOrders));
        if (winningBlocks == null) {
            return null;
        }
        Order winningOrder = myOrder.withBlocks(winningBlocks);
        double P_THRESHOLD = totalStake * 0.67;
        Order proposedOrder = this.updateProposal(winningOrder, stakedOrders, P_THRESHOLD);
        assert (proposedOrder != null);
        double C_THRESHOLD = totalStake * 0.67;
        Order consensusOrder = this.updateConsensus(proposedOrder, stakedOrders, C_THRESHOLD);
        AMap resultOrders = filteredOrders;
        if (!consensusOrder.consensusEquals(myOrder)) {
            boolean shouldReplace;
            long match = consensusOrder.getBlocks().commonPrefixLength(myOrder.getBlocks());
            long ts = mc.getTimestamp();
            boolean bl = shouldReplace = match >= myOrder.getProposalPoint();
            if (!shouldReplace) {
                long keepProposalTime = 1000L;
                if (mc.getTimestamp() > myOrder.getTimestamp() + keepProposalTime) {
                    shouldReplace = true;
                }
            }
            if (shouldReplace) {
                Order myNewOrder = consensusOrder.withTimestamp(ts);
                SignedData<Order> signedOrder2 = mc.sign(myNewOrder);
                resultOrders = ((BlobMap)resultOrders).assoc(myAddress, signedOrder2);
            }
        }
        return resultOrders;
    }

    private Order updateConsensus(final Order proposedOrder, HashMap<Order, Double> stakedOrders, double THRESHOLD) {
        Order c;
        Double chainStake;
        int i;
        final AVector<SignedData<Block>> proposedBlocks = proposedOrder.getBlocks();
        ArrayList<Order> agreedChains = Utils.sortListBy(new Function<Order, Long>(){

            @Override
            public Long apply(Order c) {
                long minProposal;
                long blockMatch = proposedBlocks.commonPrefixLength(c.getBlocks());
                long match = Math.min(blockMatch, minProposal = Math.min(proposedOrder.getProposalPoint(), c.getProposalPoint()));
                if (match <= proposedOrder.getConsensusPoint()) {
                    return null;
                }
                return -match;
            }
        }, stakedOrders.keySet());
        int numAgreed = agreedChains.size();
        double accumulatedStake = 0.0;
        for (i = 0; i < numAgreed && !((accumulatedStake += (chainStake = stakedOrders.get(c = agreedChains.get(i))).doubleValue()) > THRESHOLD); ++i) {
        }
        if (i < numAgreed) {
            long proposalMatch;
            Order lastAgreed = agreedChains.get(i);
            long prefixMatch = proposedOrder.getBlocks().commonPrefixLength(lastAgreed.getBlocks());
            long newConsensusPoint = Math.min(prefixMatch, proposalMatch = Math.min(proposedOrder.getProposalPoint(), lastAgreed.getProposalPoint()));
            if (newConsensusPoint < proposedOrder.getConsensusPoint()) {
                throw new Error("Consensus going backwards! prefix=" + prefixMatch + " propsalmatch=" + proposalMatch);
            }
            return proposedOrder.withConsenusPoint(newConsensusPoint);
        }
        return proposedOrder;
    }

    private Order updateProposal(Order winningOrder, HashMap<Order, Double> stakedOrders, double THRESHOLD) {
        Order c;
        double orderStake;
        int i;
        AVector<SignedData<Block>> winningBlocks = winningOrder.getBlocks();
        ArrayList<Order> agreedOrders = this.sortByAgreement(stakedOrders, winningBlocks);
        int numAgreed = agreedOrders.size();
        double accumulatedStake = 0.0;
        for (i = 0; i < numAgreed && !((accumulatedStake += (orderStake = stakedOrders.get(c = agreedOrders.get(i)).doubleValue())) > THRESHOLD); ++i) {
        }
        if (i < numAgreed) {
            Order lastAgreed = agreedOrders.get(i);
            AVector<SignedData<Block>> lastBlocks = lastAgreed.getBlocks();
            long newProposalPoint = winningBlocks.commonPrefixLength(lastBlocks);
            return winningOrder.withProposalPoint(newProposalPoint);
        }
        return winningOrder;
    }

    private ArrayList<Order> sortByAgreement(HashMap<Order, ?> stakedOrders, final AVector<SignedData<Block>> winningBlocks) {
        return Utils.sortListBy(new Function<Order, Long>(){

            @Override
            public Long apply(Order c) {
                long match = winningBlocks.commonPrefixLength(c.getBlocks());
                return -match;
            }
        }, stakedOrders.keySet());
    }

    private static ArrayList<SignedData<Block>> collectNewBlocks(Collection<AVector<SignedData<Block>>> orders, long consensusPoint) {
        HashSet<SignedData> newBlocks = new HashSet<SignedData>();
        ArrayList<SignedData<Block>> newBlocksOrdered = new ArrayList<SignedData<Block>>();
        for (AVector<SignedData<Block>> blks : orders) {
            if (blks.count() <= consensusPoint) continue;
            ListIterator<SignedData<Block>> it = blks.listIterator(consensusPoint);
            while (it.hasNext()) {
                SignedData b = (SignedData)it.next();
                if (newBlocks.contains(b)) continue;
                newBlocks.add(b);
                newBlocksOrdered.add(b);
            }
        }
        return newBlocksOrdered;
    }

    public static AVector<SignedData<Block>> computeWinningOrder(HashMap<Order, Double> stakedOrders, long consensusPoint, double initialTotalStake) {
        assert (!stakedOrders.isEmpty());
        HashMap votingSet = Belief.combineToBlocks(stakedOrders);
        ArrayList<SignedData<Block>> newBlocksOrdered = Belief.collectNewBlocks(votingSet.keySet(), consensusPoint);
        double totalStake = initialTotalStake;
        long point = consensusPoint;
        block0: while (votingSet.size() > 1) {
            HashMap blockVotes = new HashMap();
            for (Map.Entry<AVector<SignedData<Block>>, Double> me : votingSet.entrySet()) {
                AVector<SignedData<Block>> blocks = me.getKey();
                long cCount = blocks.count();
                if (cCount <= point) continue;
                SignedData<Block> b = blocks.get(point);
                HashMap<AVector<SignedData<Block>>, Double> agreedOrders = (HashMap<AVector<SignedData<Block>>, Double>)blockVotes.get(b);
                if (agreedOrders == null) {
                    agreedOrders = new HashMap<AVector<SignedData<Block>>, Double>();
                    blockVotes.put(b, agreedOrders);
                }
                Double stake = me.getValue();
                agreedOrders.put(blocks, stake);
                if (!(stake > totalStake * 0.5)) continue;
                votingSet.clear();
                votingSet.put(blocks, stake);
                break block0;
            }
            if (blockVotes.size() == 0) break;
            Map.Entry winningResult = null;
            double winningVote = Double.NEGATIVE_INFINITY;
            for (Map.Entry me : blockVotes.entrySet()) {
                HashMap agreedChains = (HashMap)me.getValue();
                double blockVote = Belief.computeVote(agreedChains);
                if (blockVote > winningVote) {
                    winningVote = blockVote;
                    winningResult = me;
                    continue;
                }
                if (blockVote != winningVote || ((SignedData)me.getKey()).getHash().compareTo(((SignedData)winningResult.getKey()).getHash()) >= 0) continue;
                winningResult = me;
            }
            if (winningResult == null) {
                throw new Error("This shouldn't happen!");
            }
            votingSet = (HashMap)winningResult.getValue();
            totalStake = winningVote;
            ++point;
        }
        if (votingSet.size() == 0) {
            return null;
        }
        AVector<SignedData<Block>> winningBlocks = votingSet.keySet().iterator().next();
        AVector<SignedData<Block>> fullWinningBlocks = Belief.appendNewBlocks(winningBlocks, newBlocksOrdered, consensusPoint);
        return fullWinningBlocks;
    }

    private static final AVector<SignedData<Block>> appendNewBlocks(AVector<SignedData<Block>> blocks, ArrayList<SignedData<Block>> newBlocksOrdered, long consensusPoint) {
        HashSet<SignedData<Block>> newBlocks = new HashSet<SignedData<Block>>();
        newBlocks.addAll(newBlocksOrdered);
        ListIterator<SignedData<Block>> it = blocks.listIterator(Math.min(blocks.count(), consensusPoint));
        while (it.hasNext()) {
            newBlocks.remove(it.next());
        }
        newBlocksOrdered.removeIf(b -> !newBlocks.contains(b));
        newBlocksOrdered.sort(Block.TIMESTAMP_COMPARATOR);
        AVector<SignedData<Block>> fullBlocks = blocks.appendAll(newBlocksOrdered);
        return fullBlocks;
    }

    private static HashMap<AVector<SignedData<Block>>, Double> combineToBlocks(HashMap<Order, Double> stakedOrders) {
        HashMap<AVector<SignedData<Block>>, Double> result = new HashMap<AVector<SignedData<Block>>, Double>();
        for (Map.Entry<Order, Double> e : stakedOrders.entrySet()) {
            Order c = e.getKey();
            Double stake = e.getValue();
            AVector<SignedData<Block>> blocks = c.getBlocks();
            Double acc = result.get(blocks);
            if (acc == null) {
                result.put(blocks, stake);
                continue;
            }
            result.put(blocks, acc + stake);
        }
        return result;
    }

    public static <V> double computeVote(HashMap<V, Double> m) {
        double result = 0.0;
        for (Map.Entry<V, Double> me : m.entrySet()) {
            result += me.getValue().doubleValue();
        }
        return result;
    }

    public static double prepareStakedOrders(AMap<AccountKey, SignedData<Order>> peerOrders, HashMap<AccountKey, Double> peerStakes, HashMap<Order, Double> dest) {
        return peerOrders.reduceValues((? super R acc, ? super V signedOrder) -> {
            try {
                Order order = (Order)signedOrder.getValue();
                AccountKey cAddress = signedOrder.getAccountKey();
                Double cStake = (Double)peerStakes.get(cAddress);
                if (cStake == null || cStake == 0.0) {
                    return acc;
                }
                Double stake = (Double)dest.get(order);
                if (stake == null) {
                    dest.put(order, cStake);
                } else {
                    dest.put(order, stake + cStake);
                }
                return acc + cStake;
            }
            catch (Exception e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
        }, 0.0);
    }

    private Order getMyOrder(MergeContext mc) {
        AccountKey myAddress = mc.getAccountKey();
        SignedData<Order> signed = this.orders.get(myAddress);
        if (signed == null) {
            return null;
        }
        assert (signed.getAccountKey().equals(myAddress));
        return signed.getValue();
    }

    public Belief withOrders(BlobMap<AccountKey, SignedData<Order>> newOrders) {
        if (newOrders == this.orders) {
            return this;
        }
        return Belief.create(newOrders);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.orders.estimatedEncodingSize() + 12;
    }

    public static Belief read(ByteBuffer bb) throws BadFormatException {
        BlobMap orders = (BlobMap)Format.read(bb);
        if (orders == null) {
            throw new BadFormatException("Null orders in Belief");
        }
        return new Belief(orders);
    }

    public static Belief read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        BlobMap orders = (BlobMap)Format.read(b, epos);
        if (orders == null) {
            throw new BadFormatException("Null orders in Belief");
        }
        Belief result = new Belief(orders);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(orders)));
        return result;
    }

    @Override
    public byte getTag() {
        return -86;
    }

    public Order getOrder(AccountKey address) {
        SignedData<Order> sc = this.orders.get(address);
        if (sc == null) {
            return null;
        }
        return sc.getValue();
    }

    public BlobMap<AccountKey, SignedData<Order>> getOrders() {
        return this.orders;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.orders == null) {
            throw new InvalidDataException("Null orders", this);
        }
        this.orders.validateCell();
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof Belief)) {
            return false;
        }
        Belief as = (Belief)a;
        return this.equals(as);
    }

    public boolean equals(Belief a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        return this.orders.equals(a.orders);
    }

    @Override
    public int getRefCount() {
        return this.orders.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.orders.getRef(i);
    }

    public HashMap<AccountKey, SignedData<Order>> getOrdersHashMap() {
        int n = this.orders.size();
        HashMap<AccountKey, SignedData<Order>> hm = new HashMap<AccountKey, SignedData<Order>>(n);
        for (int i = 0; i < n; ++i) {
            MapEntry<AccountKey, SignedData<Order>> entry = this.orders.entryAt(i);
            AccountKey key = RT.ensureAccountKey((ACell)entry.getKey());
            hm.put(key, (SignedData)entry.getValue());
        }
        return hm;
    }

    @Override
    public RecordFormat getFormat() {
        return BELIEF_FORMAT;
    }

    public static Collection<SignedData<Order>> extractOrders(ACell payload) {
        ArrayList<SignedData<Order>> result = new ArrayList<SignedData<Order>>();
        if (payload instanceof SignedData) {
            SignedData sd = (SignedData)payload;
            if (sd.getValue() instanceof Order) {
                result.add(sd);
            }
        } else if (payload instanceof Belief) {
            Belief b = (Belief)payload;
            BlobMap<AccountKey, SignedData<Order>> porders = b.getOrders();
            int n = porders.size();
            for (int i = 0; i < n; ++i) {
                result.add((SignedData)porders.entryAt(i).getValue());
            }
        }
        return result;
    }

    public Belief proposeBlock(AKeyPair kp, SignedData<Block> signedBlock) {
        AccountKey peerKey = kp.getAccountKey();
        BlobMap<AccountKey, SignedData<Order>> orders = this.getOrders();
        SignedData<Order> mySO = orders.get(peerKey);
        Order myOrder = mySO == null ? Order.create() : mySO.getValue();
        Order newOrder = myOrder.append(signedBlock);
        SignedData<Order> newSignedOrder = kp.signData(newOrder);
        ABlobMap newOrders = orders.assoc(peerKey, newSignedOrder);
        Belief newBelief = this.withOrders((BlobMap<AccountKey, SignedData<Order>>)newOrders);
        return newBelief;
    }
}

