/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.INumeric;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;

public final class CVMByte
extends APrimitive
implements INumeric {
    private final byte value;
    private static final CVMByte[] CACHE = new CVMByte[256];
    public static final CVMByte ZERO;
    public static final CVMByte ONE;

    private CVMByte(byte value) {
        this.value = value;
    }

    public static CVMByte create(long value) {
        return CACHE[(int)value & 0xFF];
    }

    @Override
    public AType getType() {
        return Types.BYTE;
    }

    @Override
    public long longValue() {
        return 0xFFL & (long)this.value;
    }

    @Override
    public int estimatedEncodingSize() {
        return 2;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 1;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = this.value;
        return pos;
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append(this.longValue());
    }

    @Override
    public Class<?> numericType() {
        return Long.class;
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public byte getTag() {
        return 1;
    }

    @Override
    public CVMLong toLong() {
        return CVMLong.create(this.longValue());
    }

    @Override
    public CVMDouble toDouble() {
        return CVMDouble.create(this.doubleValue());
    }

    @Override
    public CVMLong signum() {
        if (this.value == 0) {
            return CVMLong.ZERO;
        }
        return CVMLong.ONE;
    }

    public byte byteValue() {
        return this.value;
    }

    @Override
    public INumeric toStandardNumber() {
        return this.toLong();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CVMByte.CACHE[i] = new CVMByte((byte)i);
        }
        ZERO = CACHE[0];
        ONE = CACHE[1];
    }
}

