/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Format;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;

public class Symbol
extends ASymbolic {
    protected static final WeakHashMap<String, Symbol> cache = new WeakHashMap(100);

    private Symbol(String name) {
        super(name);
    }

    @Override
    public AType getType() {
        return Types.SYMBOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol create(String name) {
        if (!Symbol.validateName(name)) {
            return null;
        }
        Symbol sym = new Symbol(name);
        WeakHashMap<String, Symbol> weakHashMap = cache;
        synchronized (weakHashMap) {
            Symbol cached = cache.get(name);
            if (cached != null) {
                return cached;
            }
            cache.put(name, sym);
        }
        return sym;
    }

    public static Symbol create(AString name) {
        if (name == null) {
            return null;
        }
        return Symbol.create(name.toString());
    }

    @Override
    public boolean equals(ACell o) {
        if (o instanceof Symbol) {
            return this.equals((Symbol)o);
        }
        return false;
    }

    public boolean equals(Symbol sym) {
        return sym.name.equals(this.name);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 50;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeRawUTF8String(bs, pos, this.name.toString());
        return pos;
    }

    public static Symbol read(ByteBuffer bb) throws BadFormatException {
        String name = Format.readUTF8String(bb);
        Symbol sym = Symbol.create(name);
        if (sym == null) {
            throw new BadFormatException("Can't read symbol");
        }
        return sym;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public int estimatedEncodingSize() {
        return 50;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public byte getTag() {
        return 50;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

