/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.data.SignedData;
import convex.core.exceptions.TODOException;

public class WalletEntry {
    private final Address address;
    private final AKeyPair keyPair;
    private final AMap<Keyword, ACell> data;

    private WalletEntry(Address address, AMap<Keyword, ACell> data, AKeyPair kp) {
        this.address = address;
        this.data = data;
        this.keyPair = kp;
    }

    private WalletEntry(AMap<Keyword, ACell> data) {
        this(null, data, null);
    }

    public static WalletEntry create(Address address, AKeyPair kp) {
        return new WalletEntry(address, (AMap<Keyword, ACell>)Maps.empty(), kp);
    }

    public AccountKey getAccountKey() {
        return this.keyPair.getAccountKey();
    }

    public Address getAddress() {
        return this.address;
    }

    public AKeyPair getKeyPair() {
        if (this.keyPair == null) {
            throw new IllegalStateException("Wallet not unlocked!");
        }
        return this.keyPair;
    }

    public WalletEntry unlock(char[] password) {
        if (this.keyPair != null) {
            throw new IllegalStateException("Wallet already unlocked!");
        }
        throw new TODOException();
    }

    public WalletEntry withKeyPair(AKeyPair kp) {
        return new WalletEntry(this.address, this.data, kp);
    }

    public WalletEntry withAddress(Address address) {
        return new WalletEntry(null, this.data, this.keyPair);
    }

    public WalletEntry lock() {
        if (this.keyPair == null) {
            throw new IllegalStateException("Wallet already locked!");
        }
        return this.withKeyPair(null);
    }

    public boolean isLocked() {
        return this.keyPair == null;
    }

    public String toString() {
        return this.getAddress() + " : " + this.getAccountKey().toChecksumHex();
    }

    public <R extends ACell> SignedData<R> sign(R message) {
        return this.keyPair.signData(message);
    }
}

