/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.output;

import convex.core.text.Text;
import convex.core.util.Utils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableOutput {
    protected List<String> fieldList = new ArrayList<String>();
    protected List<List<String>> rowList = new ArrayList<List<String>>();

    public TableOutput(String ... fields) {
        this.fieldList = List.of(fields);
    }

    public void addRow(Object ... values) {
        this.rowList.add(Stream.of(values).map(v -> Utils.toString((Object)v)).collect(Collectors.toList()));
    }

    public String toString() {
        int cc = this.fieldList.size();
        int n = this.rowList.size();
        int[] sizes = new int[cc];
        for (int i = 0; i < cc; ++i) {
            sizes[i] = this.fieldList.get(i).length();
        }
        for (int j = 0; j < n; ++j) {
            List<String> row = this.rowList.get(j);
            for (int i = 0; i < cc; ++i) {
                sizes[i] = Math.max(sizes[i], row.get(i).length());
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cc; ++i) {
            String s = Text.rightPad((String)this.fieldList.get(i), (int)sizes[i]);
            sb.append(' ');
            sb.append(s);
        }
        for (int j = 0; j < n; ++j) {
            sb.append('\n');
            List<String> row = this.rowList.get(j);
            for (int i = 0; i < cc; ++i) {
                String s = Text.rightPad((String)row.get(i), (int)sizes[i]);
                sb.append(' ');
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public void writeToStream(PrintStream out) {
        this.writeToStream(new PrintWriter(out));
    }

    public void writeToStream(PrintWriter out) {
        out.println(this.toString());
    }
}

