/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import convex.cli.key.Key;
import convex.cli.mixins.KeyMixin;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PEMTools;
import convex.core.util.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", mixinStandardHelpOptions=false, description={"Export a private key from the keystore. Use with caution."})
public class KeyExport
extends AKeyCommand {
    private static final Logger log = LoggerFactory.getLogger(KeyExport.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Mixin
    protected KeyMixin keyMixin;
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the private key. Use '-' for STDOUT (default)."})
    private String outputFilename;
    @CommandLine.Option(names={"--export-password"}, description={"Password for the exported key, if applicable"})
    private String exportPassword;
    @CommandLine.Option(names={"--type"}, description={"Type of file exported. Supports: pem, seed (default)."})
    private String type;

    private void ensureExportPassword() {
        if (this.exportPassword == null && this.cli().isInteractive()) {
            this.exportPassword = new String(this.cli().readPassword("Enter passphrase for exported key: "));
        }
        if (this.exportPassword == null || this.exportPassword.length() == 0) {
            if (this.cli().isParanoid()) {
                throw new CLIError("Strict security: attempting to export PEM with no passphrase.");
            }
            log.warn("No export passphrase '--export-password' provided: Defaulting to blank.");
            this.exportPassword = "";
        }
    }

    @Override
    public void execute() {
        String output;
        String publicKey;
        AKeyPair keyPair;
        String keystorePublicKey = this.keyMixin.getPublicKey();
        if (keystorePublicKey == null || keystorePublicKey.isEmpty()) {
            if (this.outputFilename == null) {
                this.cli().inform("You must provide a --key parameter");
                this.showUsage();
                return;
            }
            keystorePublicKey = this.cli().prompt("Enter public key to export: ");
        }
        if ((keyPair = this.storeMixin.loadKeyFromStore(publicKey = keystorePublicKey, () -> this.keyMixin.getKeyPassword())) == null) {
            throw new CLIError("Key pair not found for key: " + keystorePublicKey);
        }
        if (this.type == null) {
            if (this.cli().isParanoid()) {
                throw new CLIError("Strict security: must specifiy key export type, e.g. --type=seed");
            }
            this.type = "seed";
        }
        if ("pem".equals(this.type)) {
            this.ensureExportPassword();
            try {
                String pemText;
                output = pemText = PEMTools.encryptPrivateKeyToPEM((AKeyPair)keyPair, (char[])this.exportPassword.toCharArray());
            }
            catch (GeneralSecurityException e) {
                throw new CLIError("Cannot encrypt PEM", e);
            }
        } else if ("seed".equals(this.type)) {
            String rawSeed;
            this.paranoia("Raw seed export forbidden in strict mode.");
            output = rawSeed = keyPair.getSeed().toHexString();
        } else {
            throw new CLIError("Export type not recognised: " + this.type);
        }
        if (this.outputFilename == null || "-".equals(this.outputFilename.trim())) {
            this.println(output);
        } else {
            try {
                FileUtils.writeFileAsString((Path)Paths.get(this.outputFilename, new String[0]), (String)output);
            }
            catch (IOException e) {
                throw new CLIError("Failed to write output file: " + e.getMessage());
            }
        }
    }
}

