/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.AString;
import convex.core.data.BlobBuilder;
import convex.core.data.StringShort;
import convex.core.data.StringTree;
import convex.core.data.Strings;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import java.nio.ByteBuffer;

public class StringSlice
extends AString {
    private AString source;
    private long start;

    protected StringSlice(AString source, long start2, long length) {
        super(length);
        this.source = source;
        this.start = start2;
    }

    public static AString create(StringTree source, long start2, long len) {
        if (len == 0L) {
            return StringShort.EMPTY;
        }
        if (len < 0L) {
            throw new IllegalArgumentException("Negative length");
        }
        long slen = source.length;
        if (start2 < 0L || start2 + len > slen) {
            throw new IllegalArgumentException("Out of range");
        }
        return new StringSlice(source, start2, len);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Can't encode StringSlice");
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Can't encode StringSlice");
    }

    @Override
    public int encodeRawData(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Can't encode StringSlice");
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    protected byte byteAt(long i) {
        if (i < 0L || i >= this.length) {
            return -1;
        }
        return this.source.byteAt(i + this.start);
    }

    @Override
    public AString toCanonical() {
        return Strings.create(this.toBlob());
    }

    @Override
    public ABlob toBlob() {
        return this.source.toBlob().slice(this.start, this.start + this.length);
    }

    @Override
    public int compareTo(AString o) {
        return ((AString)this.getCanonical()).compareTo(o);
    }

    @Override
    protected void writeToBuffer(ByteBuffer bb) {
        this.source.writeToBuffer(bb);
    }

    @Override
    public AString slice(long start2, long end) {
        if (start2 < 0L) {
            return null;
        }
        if (end > start2 + this.length) {
            return null;
        }
        if (start2 > end) {
            return null;
        }
        return this.source.slice(this.start + start2, this.start + end);
    }

    @Override
    protected void printEscaped(BlobBuilder sb, long start2, long end) {
        long n = this.count();
        if (start2 < 0L || start2 > end || end > n) {
            throw new IllegalArgumentException(Errors.badRange(start2, end));
        }
        this.source.printEscaped(sb, this.start + start2, this.start + end);
    }
}

