/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.CLIError;
import convex.cli.Helpers;
import convex.cli.Local;
import convex.cli.Main;
import convex.cli.peer.PeerManager;
import convex.core.crypto.AKeyPair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", mixinStandardHelpOptions=true, description={"Starts a local convex test network."})
public class LocalStart
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LocalStart.class);
    @CommandLine.ParentCommand
    private Local localParent;
    @CommandLine.Option(names={"--count"}, defaultValue="1", description={"Number of local peers to start. Default: ${DEFAULT-VALUE}"})
    private int count;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"One or more hex string of the public key in the Keystore to use to run a peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String[] keystorePublicKey;
    @CommandLine.Option(names={"--ports"}, description={"List of ports to assign to peers in the cluster. If not specified, will attempt to find available ports.or a single --ports=8081,8082,8083 or --ports=8080-8090"})
    private String[] ports;
    @CommandLine.Option(names={"--api-port"}, defaultValue="0", description={"REST API port, if set enable REST API to a peer in the local cluster"})
    private int apiPort;

    private List<AKeyPair> getPublicKeys(int n) {
        int left;
        HashSet<AKeyPair> keyPairList = new HashSet<AKeyPair>();
        Main mainParent = this.localParent.mainParent;
        if (this.keystorePublicKey.length > 0) {
            List<String> values2 = Helpers.splitArrayParameter(this.keystorePublicKey);
            for (int index = 0; index < values2.size(); ++index) {
                String keyPrefix = values2.get(index);
                AKeyPair keyPair = mainParent.loadKeyFromStore(keyPrefix);
                if (keyPair == null) {
                    throw new CLIError("Unable to find public key in store: " + keyPrefix);
                }
                keyPairList.add(keyPair);
            }
        }
        if ((left = keyPairList.size() - n) > 0) {
            log.warn("Insufficient key pairs specified. Additional keypairs will be generated");
            List<AKeyPair> kp = mainParent.generateKeyPairs(left);
            keyPairList.addAll(kp);
            mainParent.saveKeyStore();
        }
        if (keyPairList.size() < n) {
            throw new CLIError("Unable to generate sufficient keypairs!");
        }
        return new ArrayList<AKeyPair>(keyPairList);
    }

    @Override
    public void run() {
        Main mainParent = this.localParent.mainParent;
        PeerManager peerManager = PeerManager.create(mainParent.getSessionFilename());
        List<AKeyPair> keyPairList = this.getPublicKeys(this.count);
        int[] peerPorts = null;
        if (this.ports != null) {
            try {
                peerPorts = mainParent.getPortList(this.ports, this.count);
            }
            catch (NumberFormatException e) {
                log.warn("cannot convert port number " + e);
                return;
            }
            if (peerPorts.length < this.count) {
                log.warn("Only {} ports specified for {} peers", (Object)peerPorts.length, (Object)this.count);
                return;
            }
        }
        log.info("Starting local network with " + this.count + " peer(s)");
        peerManager.launchLocalPeers(keyPairList, peerPorts);
        log.info("Local Peers launched");
        if (this.apiPort > 0) {
            log.info("Starting api on port " + this.apiPort);
            peerManager.launchRestAPI(this.apiPort);
        }
        peerManager.showPeerEvents();
    }
}

