/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.menu;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialMenuUI
extends BasicMenuUI {
    protected MouseListener mouseHover = new MouseHover();
    protected JMenu menu;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.menu = (JMenu)c;
        c.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        super.uninstallUI(this.menuItem);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    @Override
    protected ChangeListener createChangeListener(JComponent c) {
        if (UIManager.getBoolean("Menu[MouseOver].enable")) {
            c.addMouseListener(this.mouseHover);
        }
        return super.createChangeListener(c);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menu.removeMouseListener(this.mouseHover);
    }

    private class MouseHover
    implements MouseListener {
        private MouseHover() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu;
            if (e.getSource() instanceof JMenu && (menu = (JMenu)e.getSource()).isEnabled()) {
                menu.setSelected(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenu menu;
            if (e.getSource() instanceof JMenu && (menu = (JMenu)e.getSource()).isEnabled()) {
                menu.setSelected(false);
            }
        }
    }
}

