/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import java.math.BigInteger;

public class Economics {
    static final BigInteger MAX_POOL_SIZE = BigInteger.valueOf(Long.MAX_VALUE);

    public static double swapRate(long a, long b) {
        if (a <= 0L || b <= 0L) {
            throw new IllegalArgumentException("Pool quantities must be positive");
        }
        return (double)b / (double)a;
    }

    public static long swapPrice(long delta, long a, long b) {
        if (a <= 0L || b <= 0L) {
            throw new IllegalArgumentException("Pool quantities must be positive");
        }
        BigInteger c = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
        long newA = a - delta;
        if (newA <= 0L) {
            throw new IllegalArgumentException("Cannot buy entire Pool");
        }
        BigInteger newBigA = BigInteger.valueOf(newA);
        if (newBigA.compareTo(MAX_POOL_SIZE) >= 0) {
            throw new IllegalArgumentException("Can't exceed Long pool size for A");
        }
        BigInteger newBigB = c.divide(newBigA);
        if (newBigB.compareTo(MAX_POOL_SIZE) >= 0) {
            throw new IllegalArgumentException("Can't exceed Long pool size for B");
        }
        long finalB = newBigB.longValueExact() + 1L;
        return finalB - b;
    }
}

