/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ALongBlob;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Strings;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public final class Address
extends ALongBlob {
    public static final Address ZERO = Address.create(0L);
    static final int BYTE_LENGTH = 8;
    public static final int MAX_ENCODING_LENGTH = 11;

    private Address(long value) {
        super(value);
    }

    public static Address create(long number) {
        if (number < 0L) {
            return null;
        }
        return new Address(number);
    }

    public static Address create(ABlob b) {
        if (b.count() != 8L) {
            return null;
        }
        return Address.create(b.longValue());
    }

    @Override
    public AType getType() {
        return Types.ADDRESS;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public boolean equals(ABlob o) {
        if (!(o instanceof Address)) {
            return false;
        }
        return this.value == ((Address)o).value;
    }

    public boolean equals(Address o) {
        return this.value == o.value;
    }

    public static Address fromHex(String hexString) {
        if (hexString == null) {
            return null;
        }
        if ((hexString.length() & 1) != 0) {
            return null;
        }
        if (hexString.length() > 16) {
            return null;
        }
        Blob b = Blob.fromHex(hexString);
        if (b == null) {
            return null;
        }
        if (b.length != 8) {
            return null;
        }
        return Address.create(b.longValue());
    }

    public static Address parse(String s) {
        if ((s = s.trim()).startsWith("#")) {
            s = s.substring(1);
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
            return Address.fromHex(s);
        }
        try {
            long l = Long.parseLong(s);
            return Address.create(l);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Address parse(Object o) {
        Number n;
        long l;
        if (o == null) {
            return null;
        }
        if (o instanceof ACell) {
            Address add = RT.castAddress((ACell)o);
            if (add != null) {
                return add;
            }
            o = RT.jvm((ACell)o);
        }
        if (o instanceof String) {
            return Address.parse((String)o);
        }
        if (o instanceof Number && (double)(l = (n = (Number)o).longValue()) == n.doubleValue()) {
            return Address.create(l);
        }
        return null;
    }

    public static Address readRaw(ByteBuffer bb) throws BadFormatException {
        long value = Format.readVLCLong(bb);
        Address a = Address.create(value);
        if (a == null) {
            throw new BadFormatException("Invalid Address: " + value);
        }
        return a;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 33;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("#");
        sb.append(Long.toString(this.value));
        return sb.check(limit);
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 2L) {
            return null;
        }
        return Strings.create("#" + this.value);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public int estimatedEncodingSize() {
        return 11;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.value < 0L) {
            throw new InvalidDataException("Address must be positive", this);
        }
    }

    @Override
    public boolean isRegularBlob() {
        return false;
    }

    @Override
    public void getBytes(byte[] dest, int destOffset) {
        Utils.writeLong(dest, destOffset, this.value);
    }

    @Override
    public Blob slice(long start2, long end) {
        return this.toFlatBlob().slice(start2, end);
    }

    @Override
    public Blob toFlatBlob() {
        byte[] bs = new byte[8];
        Utils.writeLong(bs, 0, this.value);
        return Blob.wrap(bs);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        this.toFlatBlob().updateDigest(digest);
    }

    @Override
    public boolean equalsBytes(byte[] bytes, int byteOffset) {
        return this.value == Utils.readLong(bytes, byteOffset);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return Format.writeVLCLong(bs, pos, this.value);
    }

    @Override
    public byte getTag() {
        return 33;
    }

    @Override
    public Address toCanonical() {
        return this;
    }

    public Address offset(long offset) {
        return Address.create(this.value + offset);
    }
}

