/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ABlobMap<K extends ABlob, V extends ACell>
extends AMap<K, V> {
    protected ABlobMap(long count) {
        super(count);
    }

    @Override
    public final V get(ACell key) {
        if (!(key instanceof ABlob)) {
            return null;
        }
        return this.get((ABlob)key);
    }

    @Override
    public boolean containsKey(ACell key) {
        if (!(key instanceof ABlob)) {
            return false;
        }
        return this.getEntry((ABlob)key) != null;
    }

    public abstract V get(ABlob var1);

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<MapEntry<K, V>> hs = new HashSet<MapEntry<K, V>>(this.size());
        long n = this.count();
        for (long i = 0L; i < n; ++i) {
            MapEntry<K, V> me = this.entryAt(i);
            hs.add(me);
        }
        return Collections.unmodifiableSet(hs);
    }

    @Override
    public abstract int getRefCount();

    @Override
    public abstract <R extends ACell> Ref<R> getRef(int var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public AType getType() {
        return Types.BLOBMAP;
    }

    @Override
    public abstract ABlobMap<K, V> assoc(ACell var1, ACell var2);

    @Override
    public final ABlobMap<K, V> dissoc(ACell key) {
        if (key instanceof ABlob) {
            return this.dissoc((K)((ABlob)key));
        }
        return this;
    }

    public abstract ABlobMap<K, V> dissoc(K var1);

    @Override
    public MapEntry<K, V> getKeyRefEntry(Ref<ACell> ref) {
        return this.getEntry(ref.getValue());
    }

    @Override
    public abstract MapEntry<K, V> entryAt(long var1);

    @Override
    public MapEntry<K, V> getEntry(ACell key) {
        if (key instanceof ABlob) {
            return this.getEntry((ABlob)key);
        }
        return null;
    }

    public abstract MapEntry<K, V> getEntry(ABlob var1);

    @Override
    public abstract int estimatedEncodingSize();
}

