/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.Block;
import convex.core.Order;
import convex.core.Peer;
import convex.core.State;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.gui.components.PeerView;
import convex.gui.components.models.StateModel;
import convex.gui.manager.PeerGUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class BlockViewComponent
extends JPanel {
    private PeerView peerView;

    public BlockViewComponent(PeerView peer) {
        this.peerView = peer;
        this.setBackground(null);
        this.setPreferredSize(new Dimension(1000, 10));
        if (peer != null) {
            StateModel<State> model = peer.getStateModel();
            model.addPropertyChangeListener(e -> this.repaint());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.black);
        int pw = this.getWidth();
        int ph = this.getHeight();
        g.fillRect(0, 0, pw, ph);
        Peer p = this.peerView.peerServer.getPeer();
        Order order = p.getPeerOrder();
        if (order == null) {
            return;
        }
        AVector<SignedData<Block>> blocks = order.getBlocks();
        int n = (int)blocks.count();
        int W = 10;
        long tw = (long)W * PeerGUI.maxBlock;
        long offset = Math.max(0L, tw - (long)pw);
        for (int i = (int)(offset / (long)W); i < n; ++i) {
            Color c = Color.orange;
            if ((long)i < order.getProposalPoint()) {
                c = Color.yellow;
            }
            if ((long)i < order.getConsensusPoint()) {
                c = Color.green;
            }
            if (p.getConsensusPoint() != order.getConsensusPoint()) {
                System.out.println("Strange consensus?");
            }
            int x = (int)((long)(W * i) - offset);
            g.setColor(c);
            g.fillRect(x + 1, 1, W - 2, W - 2);
            if (c != Color.green) continue;
            g.setColor(Color.black);
            State s = (State)p.getStates().get(i + 1);
            for (int j = 0; j < 6; ++j) {
                Hash h = s.getHash();
                if (h.byteAt(j) >= 0) continue;
                g.fillRect(x + 2, 2 + j, 6, 1);
            }
        }
    }
}

