/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.exceptions.TODOException;
import convex.core.util.UMath;
import convex.core.util.Utils;

public class Huge {
    public static final Huge ZERO = Huge.create(0L);
    public static final Huge ONE = Huge.create(1L);
    public final long hi;
    public final long lo;

    private Huge(long hi, long lo) {
        this.hi = hi;
        this.lo = lo;
    }

    public static Huge create(long a) {
        return new Huge(a >= 0L ? 0L : -1L, a);
    }

    public static Huge multiply(long a, long b) {
        long hi = Math.multiplyHigh(a, b);
        return new Huge(hi, a * b);
    }

    public static Huge multiply(Huge a, long b) {
        long carry = Math.multiplyHigh(a.lo, b);
        return new Huge(carry + a.hi * b, a.lo * b);
    }

    public static Huge add(long a, long b) {
        long carry = UMath.unsignedAddCarry(a, b);
        long signSum = (a < 0L ? -1 : 0) + (b < 0L ? -1 : 0);
        return new Huge(carry + signSum, a + b);
    }

    public Huge add(long b) {
        long carry = UMath.unsignedAddCarry(this.lo, b);
        long sign = b < 0L ? -1 : 0;
        return new Huge(this.hi + sign + carry, this.lo + b);
    }

    public static Long fusedMultiplyDivide(long a, long b, long c) {
        throw new TODOException();
    }

    public Huge add(Huge b) {
        long carry = UMath.unsignedAddCarry(this.lo, b.lo);
        return new Huge(this.hi + b.hi + carry, this.lo + b.lo);
    }

    public boolean equals(Object a) {
        if (a instanceof Huge) {
            return this.equals((Huge)a);
        }
        return false;
    }

    public boolean equals(Huge a) {
        return this.lo == a.lo && this.hi == a.hi;
    }

    public String toString() {
        return "#huge 0x" + Utils.toHexString(this.hi) + Utils.toHexString(this.lo);
    }

    public Huge sub(Huge b) {
        return this.add(b.negate());
    }

    public Huge negate() {
        return new Huge(-this.hi - (this.lo != 0L ? 1L : 0L), -this.lo);
    }

    public Huge mul(Huge b) {
        throw new TODOException();
    }
}

