/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.ASignature;
import convex.core.crypto.Providers;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Strings;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Ed25519Signature
extends ASignature {
    public static final int SIGNATURE_LENGTH = 64;
    public static final Ed25519Signature ZERO = Ed25519Signature.wrap(new byte[64]);
    private final byte[] signatureBytes;

    private Ed25519Signature(byte[] signature) {
        this.signatureBytes = signature;
    }

    public static Ed25519Signature wrap(byte[] signature) {
        if (signature.length != 64) {
            throw new IllegalArgumentException("Bsd signature length for ED25519");
        }
        return new Ed25519Signature(signature);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    public static Ed25519Signature read(ByteBuffer bb) throws BadFormatException {
        byte[] sigData = new byte[64];
        bb.get(sigData);
        return Ed25519Signature.wrap(sigData);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 34;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        System.arraycopy(this.signatureBytes, 0, bs, pos, 64);
        return pos + 64;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("{:signature 0x" + Utils.toHexString(this.signatureBytes) + "}");
        return bb.check(limit);
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 10L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public boolean verify(ABlob message, AccountKey publicKey) {
        boolean verified = Providers.SODIUM_SIGN.cryptoSignVerifyDetached(this.signatureBytes, message.getBytes(), (int)message.count(), publicKey.getBytes());
        return verified;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int estimatedEncodingSize() {
        return 65;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public String toHexString() {
        return Utils.toHexString(this.signatureBytes);
    }

    @Override
    public Blob getSignatureBlob() {
        return Blob.wrap(this.signatureBytes);
    }
}

