/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.Constants;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.reader.ReaderUtils;
import java.nio.ByteBuffer;

public final class CVMChar
extends APrimitive {
    public static int MAX_VALUE = 0x10FFFF;
    private static final CVMChar[] cache = new CVMChar[128];
    public static final CVMChar A;
    private final int value;

    private CVMChar(int value) {
        this.value = value;
    }

    @Override
    public AType getType() {
        return Types.CHARACTER;
    }

    public static CVMChar create(long value) {
        if (value < 0L) {
            return null;
        }
        if (value < 128L) {
            return cache[(int)value];
        }
        if (value > (long)MAX_VALUE) {
            return null;
        }
        return new CVMChar((int)value);
    }

    @Override
    public long longValue() {
        return 0xFFFFFFFFL & (long)this.value;
    }

    @Override
    public int estimatedEncodingSize() {
        return 4;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    private static int encodedCharLength(int c) {
        if ((c & 0xFFFF0000) == 0) {
            return (c & 0xFF00) == 0 ? 1 : 2;
        }
        return (c & 0xFF000000) == 0 ? 3 : 4;
    }

    public static int utfLength(int c) {
        if (c < 0) {
            return -1;
        }
        if (c <= 127) {
            return 1;
        }
        if (c <= 2047) {
            return 2;
        }
        if (c <= 65535) {
            return 3;
        }
        if (c <= MAX_VALUE) {
            return 4;
        }
        return -1;
    }

    public static CVMChar read(int len, ByteBuffer bb) throws BadFormatException {
        int value = -16777216;
        for (int i = 0; i < len; ++i) {
            if (value == 0) {
                throw new BadFormatException("Leading zero in CVMChar encoding");
            }
            byte b = bb.get();
            value = (value << 8) + (b & 0xFF);
        }
        CVMChar result = CVMChar.create(value);
        if (result == null) {
            throw new BadFormatException("CVMChar out of Unicode range");
        }
        return result;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        int len = CVMChar.encodedCharLength(this.value);
        bs[pos++] = (byte)(60 + (len - 1));
        return this.encodeRaw(len, bs, pos);
    }

    public int encodeRaw(int len, byte[] bs, int pos) {
        for (int i = 0; i < len; ++i) {
            bs[pos + i] = (byte)(this.value >> (len - (i + 1)) * 8 & 0xFF);
        }
        return pos + len;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Encoding requires a length in bytes");
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        switch (this.value) {
            case 10: {
                bb.append("\\newline");
                break;
            }
            case 13: {
                bb.append("\\return");
                break;
            }
            case 32: {
                bb.append("\\space");
                break;
            }
            case 9: {
                bb.append("\\tab");
                break;
            }
            default: {
                bb.append('\\');
                if (Character.isBmpCodePoint(this.value)) {
                    bb.append((char)this.value);
                    break;
                }
                bb.append(this.toString());
            }
        }
        return bb.check(limit);
    }

    @Override
    public String toString() {
        if (Character.isValidCodePoint(this.value)) {
            return Character.toString(this.value);
        }
        return Constants.BAD_CHARACTER_STRING;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMChar parse(String s) {
        int n = s.length();
        if (n < 2) {
            return null;
        }
        if (n == 2) {
            return CVMChar.create(s.charAt(1));
        }
        if (s.charAt(1) == 'u' && n == 6) {
            char c = (char)Long.parseLong(s.substring(2), 16);
            return CVMChar.create(c);
        }
        s = s.substring(1);
        return ReaderUtils.specialCharacter(s);
    }

    @Override
    public byte getTag() {
        return (byte)(60 + (CVMChar.encodedCharLength(this.value) - 1));
    }

    public char charValue() {
        if (Character.isBmpCodePoint(this.value)) {
            return (char)this.value;
        }
        return '\ufffd';
    }

    public byte[] toUTFBytes() {
        int n = CVMChar.utfLength(this.value);
        if (n <= 0) {
            throw new Error("Shouldn't happen: CVMChar out of range: " + this.value);
        }
        byte[] bs = new byte[n];
        if (this.value < 128) {
            bs[0] = (byte)this.value;
            return bs;
        }
        bs[0] = (byte)(65280 >> n | this.value >> (n - 1) * 6);
        for (int i = 1; i < n; ++i) {
            bs[i] = (byte)(0x80 | 0x3F & this.value >> (n - 1 - i) * 6);
        }
        return bs;
    }

    public Blob toUTFBlob() {
        return Blob.wrap(this.toUTFBytes());
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit <= 0L) {
            return null;
        }
        return Strings.create(this.toUTFBlob());
    }

    static {
        for (int i = 0; i < 128; ++i) {
            CVMChar.cache[i] = new CVMChar(i);
        }
        A = CVMChar.create(97L);
    }
}

