/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.PFXTools;
import java.io.File;
import java.security.KeyStore;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"li"}, mixinStandardHelpOptions=true, description={"List available key pairs."})
public class KeyList
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyList.class);
    @CommandLine.ParentCommand
    protected Key keyParent;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        String password = mainParent.getPassword();
        if (password == null) {
            log.warn("You need to provide a keystore password");
            return;
        }
        File keyFile = new File(mainParent.getKeyStoreFilename());
        try {
            if (!keyFile.exists()) {
                log.error("Cannot find keystore file {}", (Object)keyFile.getCanonicalPath());
            }
            KeyStore keyStore = PFXTools.loadStore(keyFile, password);
            Enumeration<String> aliases = keyStore.aliases();
            int index = 1;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                mainParent.output.setField("Index", String.format("%5d", index));
                mainParent.output.setField("Public Key", alias);
                mainParent.output.addRow();
                ++index;
            }
        }
        catch (Throwable t) {
            mainParent.showError(t);
        }
    }
}

