/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.prim.APrimitive;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.reader.ReaderUtils;
import convex.core.util.Utils;

public final class CVMChar
extends APrimitive {
    public static final CVMChar A = CVMChar.create(97L);
    private final char value;

    public CVMChar(char value) {
        this.value = value;
    }

    @Override
    public AType getType() {
        return Types.CHARACTER;
    }

    public static CVMChar create(long value) {
        return new CVMChar((char)value);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int estimatedEncodingSize() {
        return 3;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 12;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return Utils.writeChar(bs, pos, this.value);
    }

    @Override
    public void print(StringBuilder sb) {
        Object s;
        switch (this.value) {
            case '\n': {
                s = "\\newline";
                break;
            }
            case '\r': {
                s = "\\return";
                break;
            }
            case ' ': {
                s = "\\space";
                break;
            }
            case '\t': {
                s = "\\tab";
                break;
            }
            default: {
                s = "\\" + Character.toString(this.value);
            }
        }
        sb.append((String)s);
    }

    @Override
    public String toString() {
        return Character.toString(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMChar parse(String s) {
        int n = s.length();
        if (n < 2) {
            return null;
        }
        if (n == 2) {
            return CVMChar.create(s.charAt(1));
        }
        if (s.charAt(1) == 'u' && n == 6) {
            char c = (char)Long.parseLong(s.substring(2), 16);
            return CVMChar.create(c);
        }
        s = s.substring(1);
        return ReaderUtils.specialCharacter(s);
    }

    public char charValue() {
        return this.value;
    }

    @Override
    public byte getTag() {
        return 12;
    }
}

