/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class VectorTree<T extends ACell>
extends AVector<T> {
    public static final int MINIMUM_SIZE = 32;
    public static final int MAX_EMBEDDED_LENGTH = 140;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCLength(256L) + 2240;
    private final int shift;
    private final Ref<AVector<T>>[] children;

    private VectorTree(Ref<AVector<T>>[] children, long count) {
        super(count);
        this.shift = VectorTree.computeShift(count);
        this.children = children;
    }

    public static int computeShift(long count) {
        int shift = 0;
        if (count >= 0x1000000000000000L) {
            return 60;
        }
        while (1L << shift + 4 < count) {
            shift += 4;
        }
        return shift;
    }

    private long childIndex(int childNumber) {
        return (long)childNumber * this.childSize();
    }

    static int computeArraySize(long count) {
        int shift = VectorTree.computeShift(count);
        long bsize = 1L << shift;
        return (int)((count + (bsize - 1L)) / bsize);
    }

    public static <T extends ACell> VectorTree<T> create(ACell[] things, int offset, int length) {
        if (length < 32) {
            throw new IllegalArgumentException("Can't create BlockVector with insufficient size: " + length);
        }
        if ((length & 0xF) != 0) {
            throw new IllegalArgumentException("Can't create BlockVector with odd elements: " + length);
        }
        int shift = VectorTree.computeShift(length);
        int bSize = 1 << shift;
        int bNum = (length + (bSize - 1)) / bSize;
        Ref[] bs = new Ref[bNum];
        for (int i = 0; i < bNum; ++i) {
            int bLen = Math.min(bSize, length - bSize * i);
            bs[i] = Vectors.createChunked(things, offset + i * bSize, bLen).getRef();
        }
        VectorTree<T> tv = new VectorTree<T>(bs, length);
        return tv;
    }

    @Override
    public T get(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        long bSize = 1L << this.shift;
        int b = (int)(i >> this.shift);
        return this.children[b].getValue().get(i - (long)b * bSize);
    }

    @Override
    public Ref<T> getElementRef(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        long bSize = 1L << this.shift;
        int b = (int)(i >> this.shift);
        return this.children[b].getValue().getElementRef(i - (long)b * bSize);
    }

    @Override
    public <R extends ACell> AVector<R> assoc(long i, R value) {
        ASequence nc;
        if (i < 0L || i >= this.count) {
            return null;
        }
        Ref<AVector<T>>[] rchildren = this.children;
        long bSize = 1L << this.shift;
        int b = (int)(i >> this.shift);
        AVector<T> oc = rchildren[b].getValue();
        if (oc == (nc = oc.assoc(i - (long)b * bSize, (ACell)value))) {
            return this;
        }
        Ref[] newChildren = (Ref[])rchildren.clone();
        newChildren[b] = nc.getRef();
        return new VectorTree<T>(newChildren, this.count);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -128;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.count);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.children[i].encode(bs, pos);
        }
        return pos;
    }

    @Override
    public long getEncodingLength() {
        if (this.encoding != null) {
            return this.encoding.count();
        }
        long length = 1 + Format.getVLCLength(this.count);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            length += this.children[i].getEncodingLength();
        }
        return length;
    }

    @Override
    public int estimatedEncodingSize() {
        return 12 + 64 * (this.children.length + 3);
    }

    public static <T extends ACell> VectorTree<T> read(ByteBuffer bb, long count) throws BadFormatException {
        if (count < 0L) {
            throw new BadFormatException("Negative count?");
        }
        int n = VectorTree.computeArraySize(count);
        Ref[] items = new Ref[n];
        for (int i = 0; i < n; ++i) {
            Ref ref;
            items[i] = ref = Format.readRef(bb);
        }
        return new VectorTree<T>(items, count);
    }

    @Override
    public VectorTree<T> appendChunk(VectorLeaf<T> b) {
        if (b.hasPrefix()) {
            throw new IllegalArgumentException("Can't append a block with a tail");
        }
        if (b.count() != 16L) {
            throw new IllegalArgumentException("Invalid block size for append: " + b.count());
        }
        if (this.isPacked()) {
            Ref[] newBlocks = new Ref[]{this.getRef(), b.getRef()};
            return new VectorTree<T>(newBlocks, this.count() + b.count());
        }
        int blength = this.children.length;
        AVector<T> lastBlock = this.children[blength - 1].getValue();
        if (lastBlock.count() == this.childSize()) {
            Ref[] newBlocks = new Ref[blength + 1];
            System.arraycopy(this.children, 0, newBlocks, 0, blength);
            newBlocks[blength] = b.getRef();
            return new VectorTree<T>(newBlocks, this.count + 16L);
        }
        AVector<T> newLast = lastBlock.appendChunk(b);
        Ref[] newBlocks = new Ref[blength];
        System.arraycopy(this.children, 0, newBlocks, 0, blength - 1);
        newBlocks[blength - 1] = newLast.getRef();
        return new VectorTree<T>(newBlocks, this.count + 16L);
    }

    private final long childSize() {
        return 1L << this.shift;
    }

    private static long childSize(long count, int i) {
        long n = VectorTree.computeArraySize(count);
        if (i < 0 || (long)i >= n) {
            throw new IndexOutOfBoundsException("Bad child: " + i);
        }
        int shift = VectorTree.computeShift(count);
        long cs = 1L << shift;
        if ((long)i < n - 1L) {
            return cs;
        }
        return count - (n - 1L) * cs;
    }

    @Override
    public boolean isPacked() {
        return this.count == (long)(1 << this.shift + 4);
    }

    @Override
    public AVector<T> append(T value) {
        return new VectorLeaf(new Ref[]{Ref.get(value)}, this.getRef(), this.count + 1L);
    }

    @Override
    public <R extends ACell> AVector<R> concat(ASequence<R> b) {
        long bLen = b.count();
        AVector result = this;
        for (long bi = 0L; bi < bLen; bi += 16L) {
            if (bi + 16L <= bLen) {
                VectorLeaf chunk = (VectorLeaf)b.subVector(bi, 16L);
                result = result.appendChunk(chunk);
                continue;
            }
            VectorLeaf head = (VectorLeaf)b.subVector(bi, bLen - bi);
            return head.withPrefix(result);
        }
        return result;
    }

    static <T extends ACell> VectorTree<T> wrap2(VectorLeaf<T> head, VectorLeaf<T> tail) {
        Ref[] newBlocks = new Ref[]{tail.getRef(), head.getRef()};
        return new VectorTree<T>(newBlocks, 32L);
    }

    @Override
    protected <K> void copyToArray(K[] arr, int offset) {
        for (int i = 0; i < this.children.length; ++i) {
            AVector<T> b = this.children[i].getValue();
            b.copyToArray(arr, offset);
            offset = (int)((long)offset + b.count());
        }
    }

    @Override
    public long longIndexOf(Object o) {
        long offset = 0L;
        for (int i = 0; i < this.children.length; ++i) {
            AVector<T> b = this.children[i].getValue();
            long bpos = b.longIndexOf(o);
            if (bpos >= 0L) {
                return bpos + offset;
            }
            offset += b.count();
        }
        return -1L;
    }

    @Override
    public long longLastIndexOf(Object o) {
        long offset = this.count;
        for (int i = this.children.length - 1; i >= 0; --i) {
            AVector<T> b = this.children[i].getValue();
            offset -= b.count();
            long bpos = b.longLastIndexOf(o);
            if (bpos < 0L) continue;
            return bpos + offset;
        }
        return -1L;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new VectorTreeIterator();
    }

    @Override
    public ListIterator<T> listIterator(long index) {
        return new VectorTreeIterator(index);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (Ref<AVector<T>> r : this.children) {
            r.getValue().forEach(action);
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super T> pred) {
        for (Ref<AVector<AVector<T>>> ref : this.children) {
            if (!ref.getValue().anyMatch(pred)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super T> pred) {
        for (Ref<AVector<AVector<T>>> ref : this.children) {
            if (ref.getValue().allMatch(pred)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<? super T, ? extends R> mapper) {
        int blength = this.children.length;
        Ref[] newBlocks = new Ref[blength];
        for (int i = 0; i < blength; ++i) {
            ASequence r = this.children[i].getValue().map((Function)mapper);
            newBlocks[i] = r.getRef();
        }
        return new VectorTree<T>(newBlocks, this.count);
    }

    @Override
    public void visitElementRefs(Consumer<Ref<T>> f) {
        for (Ref<AVector<T>> item : this.children) {
            item.getValue().visitElementRefs(f);
        }
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super T, ? extends R> func, R value) {
        int blength = this.children.length;
        for (int i = 0; i < blength; ++i) {
            value = this.children[i].getValue().reduce(func, value);
        }
        return value;
    }

    @Override
    public Spliterator<T> spliterator(long position) {
        return new TreeVectorSpliterator(position);
    }

    @Override
    public boolean isCanonical() {
        return this.count >= 32L;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public final <R extends ACell> AVector<R> toVector() {
        assert (this.isCanonical());
        return this;
    }

    @Override
    public int getRefCount() {
        return this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int ic = this.children.length;
        if (i < 0) {
            throw new IndexOutOfBoundsException("Negative Ref index: " + i);
        }
        if (i < ic) {
            return this.children[i];
        }
        throw new IndexOutOfBoundsException("Ref index out of range: " + i);
    }

    @Override
    public VectorTree<T> updateRefs(IRefFunction func) {
        int ic = this.children.length;
        Ref<AVector<T>>[] newChildren = this.children;
        for (int i = 0; i < ic; ++i) {
            Ref<AVector<AVector<T>>> current = this.children[i];
            Ref<?> newChild = func.apply(current);
            if (newChild == current) continue;
            if (this.children == newChildren) {
                newChildren = (Ref[])this.children.clone();
            }
            newChildren[i] = newChild;
        }
        if (newChildren == this.children) {
            return this;
        }
        return new VectorTree<T>(newChildren, this.count);
    }

    @Override
    public long commonPrefixLength(AVector<T> b) {
        if (b instanceof VectorTree) {
            return this.commonPrefixLength((VectorTree)b);
        }
        return b.commonPrefixLength(this);
    }

    @Override
    private long commonPrefixLength(VectorTree<T> b) {
        long bcs;
        if (this.equals(b)) {
            return this.count;
        }
        long cs = this.childSize();
        if (cs == (bcs = b.childSize())) {
            return this.commonPrefixLengthAligned(b);
        }
        if (cs < bcs) {
            AVector<T> bChild = b.children[0].getValue();
            return this.commonPrefixLength(bChild);
        }
        AVector<T> child = this.children[0].getValue();
        return child.commonPrefixLength(b);
    }

    private long commonPrefixLengthAligned(VectorTree<T> b) {
        Hash bHash;
        Hash thisHash = this.cachedHash();
        if (thisHash != null && (bHash = b.cachedHash()) != null && thisHash.equals(bHash)) {
            return this.count;
        }
        int n = Math.min(this.children.length, b.children.length);
        long cs = this.childSize();
        long result = 0L;
        for (int i = 0; i < n; ++i) {
            long cpl = this.children[i].getValue().commonPrefixLength(b.children[i].getValue());
            if (cpl < cs) {
                return result + cpl;
            }
            result += cs;
        }
        return result;
    }

    @Override
    public VectorLeaf<T> getChunk(long offset) {
        long cs = this.childSize();
        int ix = (int)(offset / cs);
        AVector<T> child = this.children[ix].getValue();
        long cOffset = offset - (long)ix * cs;
        if (cs == 16L) {
            if (cOffset != 0L) {
                throw new IndexOutOfBoundsException("Index: " + offset);
            }
            return (VectorLeaf)child;
        }
        return child.getChunk(cOffset);
    }

    @Override
    public AVector<T> subVector(long start, long length) {
        this.checkRange(start, length);
        if ((start & 0xFL) == 0L) {
            // empty if block
        }
        ACell[] arr = new ACell[Utils.checkedInt(length)];
        int i = 0;
        while ((long)i < length) {
            arr[i] = this.get(start + (long)i);
            ++i;
        }
        return Vectors.create(arr);
    }

    @Override
    public AVector<T> next() {
        return this.slice(1L, this.count - 1L);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        long c = 0L;
        int blen = this.children.length;
        if (blen < 2) {
            throw new InvalidDataException("Insufficient children: " + blen, this);
        }
        long bsize = this.childSize();
        for (int i = 0; i < blen; ++i) {
            AVector<T> ch = this.children[i].getValue();
            if (!(ch instanceof AVector)) {
                throw new InvalidDataException("Child " + i + " is not a vector!", this);
            }
            AVector<T> b = ch;
            b.validate();
            long expectedChildSize = VectorTree.childSize(this.count, i);
            if (expectedChildSize != b.count()) {
                throw new InvalidDataException("Expected block size: " + bsize + " for blocks[" + i + "] but was: " + b.count() + " in BlockVector of size: " + this.count, this);
            }
            c += b.count();
        }
        if (c != this.count) {
            throw new InvalidDataException("Expected count: " + this.count + " but sum of child sizes was: " + c, this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        int blen = this.children.length;
        if (this.count < (long)blen) {
            throw new InvalidDataException("Implausible low count: " + this.count, this);
        }
        if (blen < 2) {
            throw new InvalidDataException("Insufficient children: " + blen, this);
        }
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    private class VectorTreeIterator
    implements ListIterator<T> {
        int bpos;
        ListIterator<T> sub;

        public VectorTreeIterator() {
            this(0L);
        }

        public VectorTreeIterator(long index) {
            long ix = index;
            if (index < 0L) {
                throw new IndexOutOfBoundsException((int)index);
            }
            this.bpos = 0;
            for (int i = 0; i < VectorTree.this.children.length; ++i) {
                AVector b = VectorTree.this.children[this.bpos].getValue();
                long bc = b.count();
                if (ix <= bc) {
                    this.sub = b.listIterator(ix);
                    return;
                }
                ix -= bc;
                ++this.bpos;
            }
            throw new IndexOutOfBoundsException((int)index);
        }

        @Override
        public boolean hasNext() {
            if (this.sub.hasNext()) {
                return true;
            }
            return this.bpos < VectorTree.this.children.length - 1;
        }

        @Override
        public T next() {
            if (this.sub.hasNext()) {
                return (ACell)this.sub.next();
            }
            if (this.bpos < VectorTree.this.children.length - 1) {
                ++this.bpos;
                this.sub = VectorTree.this.children[this.bpos].getValue().listIterator();
                return (ACell)this.sub.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            if (this.sub.hasPrevious()) {
                return true;
            }
            return this.bpos > 0;
        }

        @Override
        public T previous() {
            if (this.sub.hasPrevious()) {
                return (ACell)this.sub.previous();
            }
            if (this.bpos > 0) {
                --this.bpos;
                AVector b = VectorTree.this.children[this.bpos].getValue();
                this.sub = b.listIterator(b.count());
                return (ACell)this.sub.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return Utils.checkedInt(VectorTree.this.childIndex(this.bpos) + (long)this.sub.nextIndex());
        }

        @Override
        public int previousIndex() {
            return Utils.checkedInt(VectorTree.this.childIndex(this.bpos) + (long)this.sub.previousIndex());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }
    }

    private class TreeVectorSpliterator
    implements Spliterator<T> {
        long pos = 0L;

        public TreeVectorSpliterator(long position) {
            if (position < 0L || position > VectorTree.this.count) {
                throw new IllegalArgumentException(Errors.illegalPosition(position));
            }
            this.pos = position;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.pos >= VectorTree.this.count) {
                return false;
            }
            action.accept(VectorTree.this.get(this.pos++));
            return true;
        }

        @Override
        public Spliterator<T> trySplit() {
            for (int i = 0; i < VectorTree.this.children.length; ++i) {
                long bpos = VectorTree.this.childIndex(i);
                AVector b = VectorTree.this.children[i].getValue();
                long bcount = b.count();
                long blockEnd = VectorTree.this.childIndex(i) + bcount;
                if (this.pos >= blockEnd) continue;
                Spliterator ss = b.spliterator(this.pos - bpos);
                this.pos = blockEnd;
                return ss;
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return VectorTree.this.count;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }
}

