/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ALongBlob;
import convex.core.data.Blob;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.security.MessageDigest;

public final class LongBlob
extends ALongBlob {
    public static final int MAX_ENCODING_LENGTH = 10;

    private LongBlob(long value) {
        super(value);
    }

    public static LongBlob create(String string) {
        byte[] bs = Utils.hexToBytes(string);
        if ((long)bs.length != 8L) {
            throw new IllegalArgumentException("Long blob requires a length 8 hex string");
        }
        return new LongBlob(Utils.readLong(bs, 0));
    }

    public static LongBlob create(long value) {
        return new LongBlob(value);
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public void getBytes(byte[] dest, int destOffset) {
        Utils.writeLong(dest, destOffset, this.value);
    }

    @Override
    public ABlob slice(long start, long length) {
        if (start == 0L && length == 8L) {
            return this;
        }
        if (start < 0L) {
            throw new IndexOutOfBoundsException(Errors.badRange(start, length));
        }
        return this.getEncoding().slice(start + 2L, length);
    }

    @Override
    public Blob toBlob() {
        return this.getEncoding().slice(2L, 8L);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        byte[] bs = this.getEncoding().getInternalArray();
        digest.update(bs, 2, 8);
    }

    @Override
    public int getHexDigit(long i) {
        if (i < 0L || i >= 16L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return 0xF & (int)(this.value >> (int)((16L - i - 1L) * 4L));
    }

    @Override
    public long commonHexPrefixLength(ABlob b) {
        if (b == this) {
            return 16L;
        }
        long max = Math.min(8L, b.count());
        for (long i = 0L; i < max; ++i) {
            byte bi;
            byte ai = this.getUnchecked(i);
            if (ai == (bi = b.getUnchecked(i))) continue;
            return i * 2L + (long)(Utils.firstDigitMatch(ai, bi) ? 1 : 0);
        }
        return max * 2L;
    }

    @Override
    public boolean equals(ABlob a) {
        if (a instanceof LongBlob) {
            return ((LongBlob)a).value == this.value;
        }
        if (a instanceof Blob) {
            Blob b = (Blob)a;
            return b.count() == 8L && b.longValue() == this.value;
        }
        return false;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = 8;
        Utils.writeLong(bs, pos, this.value);
        return pos + 8;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public long hexMatchLength(ABlob b, long start, long length) {
        if (b == this) {
            return length;
        }
        long end = start + length;
        for (long i = start; i < end; ++i) {
            if (this.getHexDigit(i) == b.getHexDigit(i)) continue;
            return i - start;
        }
        return length;
    }

    @Override
    public boolean isRegularBlob() {
        return true;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public boolean equalsBytes(byte[] bytes, int byteOffset) {
        return this.value == Utils.readLong(bytes, byteOffset);
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public Blob toCanonical() {
        return this.toBlob();
    }
}

