/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PEMTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", aliases={"ex"}, mixinStandardHelpOptions=true, description={"Export 1 or more key pairs from the keystore."})
public class KeyExport
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyExport.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Option(names={"-i", "--index-key"}, description={"Keystore index of the public/private key to use for the peer."})
    private int[] keystoreIndex;
    @CommandLine.Option(names={"--public-key"}, description={"Hex string of the public key in the Keystore to use for the peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String[] keystorePublicKey;
    @CommandLine.Option(names={"--export-password"}, description={"Password of the exported key."})
    private String exportPassword;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        if (this.keystoreIndex == null && this.keystorePublicKey == null) {
            log.warn("You need to provide at least on --index-key or --public-key parameter");
            return;
        }
        if (this.exportPassword == null || this.exportPassword.length() == 0) {
            log.warn("You need to provide an export password '--export-password' of the exported key");
            return;
        }
        try {
            int index = 0;
            int count = 0;
            if (this.keystoreIndex != null) {
                count = this.keystoreIndex.length;
            }
            if (this.keystorePublicKey != null) {
                count = this.keystorePublicKey.length;
            }
            while (index < count) {
                String publicKey = null;
                int indexKey = 0;
                if (this.keystoreIndex != null) {
                    indexKey = this.keystoreIndex[index];
                }
                if (this.keystorePublicKey != null) {
                    publicKey = this.keystorePublicKey[index];
                }
                AKeyPair keyPair = mainParent.loadKeyFromStore(publicKey, indexKey);
                String pemText = PEMTools.encryptPrivateKeyToPEM(keyPair.getPrivate(), this.exportPassword.toCharArray());
                mainParent.output.setField("index", String.format("%5d", index + 1));
                mainParent.output.setField("publicKey", keyPair.getAccountKey().toHexString());
                mainParent.output.setField("export", pemText);
                mainParent.output.addRow();
                ++index;
            }
        }
        catch (Error e) {
            mainParent.showError(e);
        }
    }
}

