/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.cli.CLIError;
import convex.cli.mixins.AMixin;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

public class RemotePeerMixin
extends AMixin {
    @CommandLine.Option(names={"--port"}, defaultValue="${env:CONVEX_PORT:-18888}", description={"Port number to connect to a peer. Defaulting to: ${DEFAULT-VALUE}"})
    private Integer port;
    @CommandLine.Option(names={"--host"}, defaultValue="${env:CONVEX_HOST:-localhost}", description={"Hostname for remote peer connection. Can specify with CONVEX_HOST. Defaulting to: ${DEFAULT-VALUE}"})
    private String hostname;

    public Convex connect() {
        if (this.port == null) {
            this.port = 18888;
        }
        if (this.hostname == null) {
            this.hostname = "localhost";
        }
        InetSocketAddress sa = new InetSocketAddress(this.hostname, (int)this.port);
        try {
            ConvexRemote c = Convex.connect((InetSocketAddress)sa);
            return c;
        }
        catch (ConnectException ce) {
            throw new CLIError("Cannot connect to: " + String.valueOf(sa), ce);
        }
        catch (TimeoutException e) {
            throw new CLIError("Timeout while attempting to connect to peer: " + this.hostname, e);
        }
        catch (IOException e) {
            throw new CLIError("IO Error: " + e.getMessage(), e);
        }
    }
}

