/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.BIP39;
import convex.core.data.ABlob;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Hash;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import picocli.CommandLine;

@CommandLine.Command(name="generate", aliases={"gen"}, mixinStandardHelpOptions=true, description={"Generate private key pair(s) in the currently configured keystore."})
public class KeyGenerate
extends AKeyCommand {
    @CommandLine.Option(names={"--count"}, defaultValue="1", description={"Number of keys to generate. Default: ${DEFAULT-VALUE}"})
    private int count;
    @CommandLine.Option(names={"--words"}, defaultValue="12", description={"Number of words in BIP39 mnemonic. Default: ${DEFAULT-VALUE}"})
    private int words;
    @CommandLine.Option(names={"--type"}, defaultValue="bip39", description={"Type of key generation. Supports random, bip39, entropy"})
    private String type;
    @CommandLine.Option(names={"--passphrase"}, description={"BIP39 passphrase. If not provided, will be requested from user (or assumed blank in non-interactive mode)."})
    private String passphrase;
    @CommandLine.Option(names={"-p", "--keypass"}, defaultValue="${env:CONVEX_KEY_PASSWORD}", scope=CommandLine.ScopeType.INHERIT, description={"Key pair password for generated key. Can specify with CONVEX_KEY_PASSWORD."})
    protected char[] keyPassword;

    private AKeyPair generateKeyPair() {
        if ("bip39".equals(this.type)) {
            if (this.words < 12) {
                this.paranoia("Can't use less than 12 BIP39 words in strict security mode");
            }
            String mnemonic = BIP39.createSecureMnemonic((int)this.words);
            this.inform("BIP39 mnemonic generated with " + this.words + " words:");
            this.inform(mnemonic);
            if (this.passphrase == null) {
                if (this.isInteractive()) {
                    this.passphrase = new String(this.readPassword("Enter BIP39 passphrase: "));
                } else {
                    this.paranoia("Passphrase must be explicity provided");
                    this.passphrase = "";
                }
            }
            if (this.passphrase.isBlank()) {
                this.paranoia("Cannot use an empty BIP39 passphrase for key generation with strict security");
            }
            Blob bipseed = BIP39.getSeed((String)mnemonic, (String)this.passphrase);
            AKeyPair result = BIP39.seedToKeyPair((Blob)bipseed);
            return result;
        }
        if ("random".equals(this.type)) {
            return AKeyPair.generate();
        }
        if ("entropy".equals(this.type)) {
            if (!this.isInteractive()) {
                throw new CLIError(64, "Entropy based genration requires interactive mode");
            }
            this.inform("Press some random keys to generate entropy. Press ENTER to finish.");
            Hash h = Blob.createRandom((Random)new SecureRandom(), (long)64L).getContentHash();
            try {
                int c;
                do {
                    c = System.console().reader().read();
                    ABlob entropy = Blobs.forLong((long)c).append((ABlob)Blobs.forLong((long)System.currentTimeMillis()));
                    h = h.append(entropy).getContentHash();
                    this.informWarning(h.getContentHash().toHexString());
                } while (c != 13 && c != 10);
            }
            catch (IOException e) {
                throw new CLIError(74, "Unable to collect entropy");
            }
            return AKeyPair.create((Blob)h.toFlatBlob());
        }
        throw new CLIError(64, "Unsupprted key generation type: " + this.type);
    }

    @Override
    public void execute() {
        if (this.count <= 0) {
            this.informWarning("No keys generated. Perhaps you want a positive --count ?");
            return;
        }
        for (int index = 0; index < this.count; ++index) {
            AKeyPair kp = this.generateKeyPair();
            String publicKeyHexString = kp.getAccountKey().toHexString();
            this.storeMixin.ensureKeyStore();
            this.inform("Generated key pair with public key: 0x" + kp.getAccountKey().toChecksumHex());
            if (this.keyPassword == null) {
                this.keyPassword = this.readPassword("Enter password for generated key: ");
            }
            this.storeMixin.addKeyPairToStore(kp, this.keyPassword);
            this.println(publicKeyHexString);
            Arrays.fill(this.keyPassword, 'p');
        }
        this.storeMixin.saveKeyStore();
        this.informSuccess(this.count + " key(s) generated and saved in store " + String.valueOf(this.storeMixin.getStorePath()));
    }
}

