/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.client;

import convex.api.Convex;
import convex.cli.ATopCommand;
import convex.cli.CLIError;
import convex.cli.mixins.AddressMixin;
import convex.cli.mixins.KeyMixin;
import convex.cli.mixins.KeyStoreMixin;
import convex.cli.mixins.RemotePeerMixin;
import convex.core.crypto.AKeyPair;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import picocli.CommandLine;

public abstract class AClientCommand
extends ATopCommand {
    @CommandLine.Mixin
    protected KeyStoreMixin storeMixin;
    @CommandLine.Mixin
    protected KeyMixin keyMixin;
    @CommandLine.Mixin
    protected RemotePeerMixin peerMixin;
    @CommandLine.Mixin
    protected AddressMixin addressMixin;
    @CommandLine.Option(names={"--timeout"}, description={"Timeout in miliseconds."})
    private Long timeout;

    protected long getClientTimeout() {
        return this.timeout == null ? 10000L : this.timeout;
    }

    protected Convex clientConnect() {
        Convex convex = this.peerMixin.connect();
        if (this.timeout != null) {
            convex.setTimeout(this.timeout.longValue());
        }
        return convex;
    }

    protected Convex connectQuery() {
        Convex convex = this.clientConnect();
        Address a = this.getUserAddress();
        convex.setAddress(a);
        return convex;
    }

    protected Convex connectTransact() throws InterruptedException {
        Convex convex = this.connectQuery();
        this.ensureKeyPair(convex);
        return convex;
    }

    public Address getUserAddress() {
        return this.addressMixin.getAddress("Enter Convex user account address: ");
    }

    protected void ensureKeyPair(Convex convex) throws InterruptedException {
        Address a = convex.getAddress();
        AKeyPair keyPair = convex.getKeyPair();
        if (keyPair != null) {
            return;
        }
        String pk = this.keyMixin.getPublicKey();
        if (pk == null) {
            this.paranoia("You must set --key explicitly in strict security mode");
            AccountKey k = convex.getAccountKey(a);
            if (k != null) {
                pk = k.toHexString();
                this.inform("Address " + String.valueOf(a) + " requires public key " + pk);
            } else if (this.isInteractive()) {
                pk = this.prompt("Enter public key for Address " + String.valueOf(a) + ": ");
            } else {
                throw new CLIError(64, "Public key required.");
            }
        }
        this.storeMixin.ensureKeyStore();
        int c = this.storeMixin.keyCount(pk);
        if (c == 0) {
            throw new CLIError(78, "Can't find keypair with public key: " + pk);
        }
        if (c > 1) {
            throw new CLIError(78, "Multiple key pairs found");
        }
        keyPair = this.storeMixin.loadKeyFromStore(pk, this.keyMixin.getKeyPassword());
        if (keyPair == null) {
            throw new CLIError(78, "Can't find keypair with public key: " + pk);
        }
        convex.setKeyPair(keyPair);
    }
}

