/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.shadows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Objects;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialDrawingUtils;

public class RoundedCornerBorder
extends AbstractBorder {
    protected int arch = 12;
    protected Color colorLine;
    protected float withBorder = 1.2f;

    public RoundedCornerBorder() {
        this.colorLine = MaterialColors.LIGHT_BLUE_400;
    }

    public RoundedCornerBorder(Color colorLine) {
        this.colorLine = colorLine;
    }

    public RoundedCornerBorder(Color colorLine, int arch) {
        this.colorLine = colorLine;
        this.arch = arch;
    }

    public RoundedCornerBorder(int arch, Color colorLine, float withBorder) {
        this.arch = arch;
        this.colorLine = colorLine;
        this.withBorder = withBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(this.withBorder));
        int r = this.arch;
        int w = width - 1;
        int h = height - 1;
        Area round = new Area(new RoundRectangle2D.Double(x, y, w, h, r, r));
        if (c instanceof JPopupMenu) {
            g2.setPaint(c.getBackground());
            g2.fill(round);
        } else {
            Container parent = c.getParent();
            if (Objects.nonNull(parent)) {
                g2.setPaint(parent.getBackground());
                Area corner = new Area(new RoundRectangle2D.Float(x, y, width, height, r, r));
                corner.subtract(round);
                g2.fill(corner);
            }
        }
        g2.setPaint(this.colorLine);
        g2.draw(round);
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(4, 8, 4, 8);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(4, 8, 4, 8);
        return insets;
    }
}

