/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Order;
import convex.core.Peer;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.peer.ConnectionManager;
import convex.peer.Server;

public class ServerInformation {
    private AccountKey peerKey;
    private String hostname;
    private int connectionCount;
    private int trustedConnectionCount;
    private boolean isSynced;
    private boolean isJoined;
    private Hash networkID;
    private long consensusPoint;
    private Hash stateHash;
    private Hash beliefHash;
    private long blockCount;

    private ServerInformation(Server server, ConnectionManager manager) {
        this.load(server, manager);
    }

    public static ServerInformation create(Server server) {
        return new ServerInformation(server, server.getConnectionManager());
    }

    protected void load(Server server, ConnectionManager manager) {
        Peer peer = server.getPeer();
        Order order = peer.getPeerOrder();
        this.peerKey = peer.getPeerKey();
        this.hostname = server.getHostname();
        this.connectionCount = manager.getConnectionCount();
        this.trustedConnectionCount = manager.getTrustedConnectionCount();
        this.isSynced = order != null && peer.getConsensusPoint() > 0L;
        this.networkID = peer.getNetworkID();
        this.consensusPoint = peer.getConsensusPoint();
        this.isJoined = this.connectionCount > 0;
        this.stateHash = peer.getConsensusState().getHash();
        this.beliefHash = peer.getBelief().getHash();
        this.blockCount = 0L;
        if (order != null) {
            this.blockCount = order.getBlockCount();
        }
    }

    public AccountKey getPeerKey() {
        return this.peerKey;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getTrustedConnectionCount() {
        return this.trustedConnectionCount;
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public boolean isJoined() {
        return this.isJoined;
    }

    public Hash getNetworkID() {
        return this.networkID;
    }

    public long getConsensusPoint() {
        return this.consensusPoint;
    }

    public Hash getStateHash() {
        return this.stateHash;
    }

    public Hash getBeliefHash() {
        return this.beliefHash;
    }

    public long getBlockCount() {
        return this.blockCount;
    }
}

